# In-context samples for articulationer system prompt
# This file stores general in-context samples for various articulated objects, not limited to keyboards.

samples = r'''
Input Example:
workflow.json:
{{
  "description": "A bottle composed of a base, body, neck, and a movable lip (e.g., a push-pull sports bottle cap).",
  "threejs_info": [
    {{"name": "base"}},
    {{"name": "body"}},
    {{"name": "neck"}},
    {{"name": "lip"}}
  ]
}}

Output Example:
[
  {{
    "joint_name": "base_to_body",
    "parent": "base",
    "child": "body",
    "type": "fixed",
    "notes": "Connecting the base to the body. A standard bottle is a rigid object, so all joints connecting its parts are fixed except the cap. Joint origin is omitted as mesh files define the position."
  }},
  {{
    "joint_name": "body_to_neck",
    "parent": "body",
    "child": "neck",
    "type": "fixed",
    "notes": "Connecting the body to the neck. A standard bottle is a rigid object, so all joints connecting its parts are fixed except the cap. Joint origin is omitted as mesh files define the position."
  }},
  {{
    "joint_name": "neck_to_lip",
    "parent": "neck",
    "child": "lip",
    "type": "prismatic",
    "axis": [0, 0, 1],
    "limit": {{"lower": 0.0, "upper": 0.02, "effort": 5, "velocity": 0.05}},
    "notes": "The lip (cap) can slide up and down along the neck, as in a push-pull sports bottle. Joint origin is omitted as mesh files define the position."
  }}
]

Input Example:
workflow.json:
{{
  "description": "A keyboard with a base and multiple individual keys. Each key can be pressed down independently.",
  "threejs_info": [
    {{"name": "base"}},
    {{"name": "key_A"}},
    {{"name": "key_B"}},
    {{"name": "key_C"}}
    // ... more keys as needed
  ]
}}

Output Example:
[
  {{
    "joint_name": "base_to_key_A",
    "parent": "base",
    "child": "key_A",
    "type": "prismatic",
    "axis": [0, 0, -1],
    "limit": {{"lower": 0.0, "upper": 0.01, "effort": 2, "velocity": 0.1}},
    "notes": "Each key moves vertically downwards (Z axis negative) with a short travel. Each key is a separate link and has its own prismatic joint."
  }},
  {{
    "joint_name": "base_to_key_B",
    "parent": "base",
    "child": "key_B",
    "type": "prismatic",
    "axis": [0, 0, -1],
    "limit": {{"lower": 0.0, "upper": 0.01, "effort": 2, "velocity": 0.1}},
    "notes": "Each key moves vertically downwards (Z axis negative) with a short travel. Each key is a separate link and has its own prismatic joint."
  }},
  {{
    "joint_name": "base_to_key_C",
    "parent": "base",
    "child": "key_C",
    "type": "prismatic",
    "axis": [0, 0, -1],
    "limit": {{"lower": 0.0, "upper": 0.01, "effort": 2, "velocity": 0.1}},
    "notes": "Each key moves vertically downwards (Z axis negative) with a short travel. Each key is a separate link and has its own prismatic joint."
  }}
  // ... more keys as needed
]

Input Example:
workflow.json:
{{
  "description": "A laptop with a base and a screen connected by a hinge.",
  "threejs_info": [
    {{
      "name": "base",
      "boundingBox": {{
        "min": [-0.25, -0.01, -0.15],
        "max": [0.25, 0.018, 0.15]
      }}
    }},
    {{
      "name": "screen",
      "boundingBox": {{
        "min": [-0.25, 0.003, -0.383],
        "max": [0.25, 0.249, -0.143]
      }}
    }}
  ]
}}

Output Example:
[
  {{
    "joint_name": "screen_hinge",
    "parent": "base",
    "child": "screen",
    "type": "revolute",
    "axis": [1, 0, 0],
    "origin": {{"xyz": [0, 0.01046447, -0.14646447], "rpy": [0, 0, 0]}},
    "limit": {{"lower": 0, "upper": 1.5, "effort": 1, "velocity": 1}},
    "notes": "The screen rotates about the X axis (hinge runs along X) at the top edge of the base. The origin is set at the intersection of the base's top and the screen's bottom, matching the bounding box Y and Z values. This matches the real-world laptop hinge mechanism. The axis is chosen based on the physical design and bounding box alignment."
  }}
]
''' 