# URDF Grid Visualizer

## Quick Start

```bash
# Start server (auto-detects 2-level or 3-level directory structure)
./start.sh [path] [port]

# Default: path=/lab/yipeng/generated_art_objects/eval_09_18, port=3001
./start.sh
```

## Access
- **Batch Preview**: http://localhost:3001/preview
- **Interactive Viewer**: http://localhost:3001/viewer/[category]/[instance]

## Directory Structure Support

### 2-Level (Auto-detected)
```
eval_09_18/
├── a_camera_1/
│   ├── generated.urdf
│   └── part_meshes/
```

### 3-Level (Auto-detected)
```
eval_09_01/
├── camera/
│   └── a_camera_1/
│       ├── generated.urdf
│       └── part_meshes/
```

## Files
```
server/
├── server.js              # Main server with auto-detection
├── views/
│   ├── batch_preview.html      # Grid preview
│   └── interactive_viewer.html  # 3D viewer
└── public/js/
    ├── adaptive_camera.js      # Smart camera controls
    ├── URDFLoader.js           # URDF loader
    └── OBJLoader.js            # OBJ mesh loader
```