import numpy as np
import math
import scipy
from numpy import sqrt
import random as rd
from numpy.random import RandomState
from numpy.random import rand, randn
from scipy.linalg import qr
from dppy.finite_dpps import *
import matplotlib.pyplot as plt
from scipy.stats import unitary_group
from scipy.stats import ortho_group
import itertools
from scipy.optimize import minimize, LinearConstraint
from scipy.optimize import rosen
from scipy.optimize import linprog
import seaborn as sb
import time
import copy


################################################################################################################################
################################################################################################################################



#enter dimension below (n1)
n1 =  8				




################################################################################################################################
################################################################################################################################




no_of_times = 50
max_iter = 50
delta = 0.002
m1 = 4			
fw_stepsize = 50
fws_stepsize = 50 
cg_stepsize = 50
mcg_stepsize = 50
pga_stepsize = 50
lamb = 0.5
eps_inv_for_nofw = 4
eps_for_nofw = 1/eps_inv_for_nofw
rng = np.random.default_rng()
no_of_times = 50
x_plot = list(range(1, max_iter+1))
A1 = np.zeros((m1, n1))
b1 = np.ones(shape = (m1,1))+ (A1 @ np.ones(shape = (n1,1)))



def qpobjective1(x, lamb, X):
	out = np.zeros(shape = (n1,n1))
	for i in range(n1):
		a = np.reshape(X[i], (n1,1))
		out = out + x[i]*( a @ np.transpose(a))
	return(lamb*np.log(np.linalg.det(out)))



def logconcaveobjective(x, lamb, X):
	return((1-lamb)*0.1*(np.sum(np.log(np.array(x))) ))				




def fullobjective(x, lamb, X):
	return(qpobjective1(x, lamb, X) + logconcaveobjective(x, lamb, X))




def basis(size, index):
	y = np.array([1.0 if i == index else 0.0 for i in range(size)])
	return(y)



def gradcal1(H, x, lamb, X): 		
	gradient = np.array([0.0 for i in range(n1)])
	for i in range(n1):
		p = (H(x + basis(n1, i)*delta, lamb, X) - H(x, lamb, X))/delta
		if p <= 0.5:
			gradient[i] = p
		elif p > 0.5:
			gradient[i] = (H(x, lamb, X) - H(x - basis(n1, i)*delta, lamb, X))/delta
	return(gradient)



def gradcal_auxiliaryG(x, X):
	gradient = np.array([0.0 for i in range(n1)])
	for j in range(1, eps_inv_for_nofw + 1):
		gradient = gradient + (((math.e)**(eps_for_nofw*j))*gradcal1(qpobjective1, (eps_for_nofw*j)*x, lamb, X))/(eps_for_nofw*j)
	gradient = eps_for_nofw*gradient
	return(gradient)





def fwolfe1(epsilon, qpobjective1, logconcaveobjective, y, lamb, X):			
	potential_answers = []
	it = 0
	while it < max_iter:
		p = gradcal1(qpobjective1, y, lamb, X)
		q = gradcal1(logconcaveobjective, y, lamb, X)
		r = p + 2*q
		c = np.array(r)
		c = -c
		bounds_arg = []
		for i in range(n1):
			bounds_arg.append((1, 2))
		res = linprog(c, A_ub=A1, b_ub=b1, bounds = bounds_arg)
		x_ = res.x
		x_ = np.array(x_)
		y = np.array(y)
		y = (1 - epsilon)*y + epsilon*x_
		potential_answers.append(y)		
		it = it+1
	final_out = []
	for i in potential_answers:
		final_out.append(fullobjective(i, lamb, X))
	y_plot = final_out
	return(y_plot)



def nofwolfe1(epsilon, qpobjective1, logconcaveobjective, y, lamb, X):			
	potential_answers = []
	it = 0
	while it < max_iter:
		p = (1/math.e)*gradcal_auxiliaryG(y, X)
		q = gradcal1(logconcaveobjective, y, lamb, X)
		r = p + q
		c = np.array(r)
		c = -c
		bounds_arg = []
		for i in range(n1):
			bounds_arg.append((1, 2))
		res = linprog(c, A_ub=A1, b_ub=b1, bounds = bounds_arg)
		x_ = res.x
		x_ = np.array(x_)
		y = np.array(y)
		y = (1 - epsilon)*y + epsilon*x_
		potential_answers.append(y)		
		it = it+1
	final_out = []
	for i in potential_answers:
		final_out.append(fullobjective(i, lamb, X))
	y_plot = final_out
	return(y_plot)





def fwolfesimple1(epsilon, qpobjective1, logconcaveobjective, y, lamb, X):			
	potential_answers = []
	it = 0
	while it < max_iter:
		p = gradcal1(qpobjective1, y, lamb, X)
		q = gradcal1(logconcaveobjective, y, lamb, X)
		r = p + q
		c = np.array(r)
		c = -c
		bounds_arg = []
		for i in range(n1):
			bounds_arg.append((1, 2))
		res = linprog(c, A_ub=A1, b_ub=b1, bounds = bounds_arg)
		x_ = res.x
		x_ = np.array(x_)
		y = np.array(y)
		y = (1 - epsilon)*y + epsilon*x_
		potential_answers.append(y)		
		it = it+1
	final_out = []
	for i in potential_answers:
		final_out.append(fullobjective(i, lamb, X))
	y_plot = final_out
	return(y_plot)





def contgreedy1(epsilon, qpobjective1, logconcaveobjective, y, lamb, X):			
	potential_answers = []
	it = 0
	while it < max_iter:
		p = gradcal1(qpobjective1, y, lamb, X)
		q = gradcal1(logconcaveobjective, y, lamb, X)
		r = p + q
		c = np.array(r)
		c = -c
		bounds_arg = []
		for i in range(n1):
			bounds_arg.append((1, 2))
		res = linprog(c, A_ub=A1, b_ub=b1, bounds = bounds_arg)
		x_ = res.x
		x_ = np.array(x_)
		y = np.array(y)
		y = y + epsilon*x_
		potential_answers.append(y)		
		it = it+1
	y_plot = []
	for i in potential_answers:
		y_plot.append(fullobjective(i, lamb, X))
	return(y_plot)



def meascontgreedy1(epsilon, qpobjective1, logconcaveobjective, y, lamb, X):			
	potential_answers = []
	it = 0
	while it < max_iter:
		p = gradcal1(qpobjective1, y, lamb, X)
		q = gradcal1(logconcaveobjective, y, lamb, X)
		r = np.multiply(2*np.ones(n1) - y, p+q)
		c = np.array(r)
		c = -c
		bounds_arg = []
		for i in range(n1):
			bounds_arg.append((1, 2))
		res = linprog(c, A_ub=A1, b_ub=b1, bounds = bounds_arg)
		x_ = res.x
		x_ = np.array(x_)
		x_ = np.multiply(2*np.ones(n1) - y, x_)
		y = np.array(y)
		y = y + epsilon*x_
		potential_answers.append(y)		
		it = it+1
	y_plot = []
	for i in potential_answers:
		y_plot.append(fullobjective(i, lamb, X))
	return(y_plot)



def projga1(epsilon, qpobjective1, logconcaveobjective, y, lamb, X):
	potential_answers = []
	it = 0
	while it < max_iter:
		p = gradcal1(qpobjective1, y, lamb, X)
		q = gradcal1(logconcaveobjective, y, lamb, X)
		r = p + q
		y = np.array(y)
		y = y + epsilon*r	
		y = np.clip(y, 1, 2)
		potential_answers.append(np.array(y))		
		it = it+1
	y_plot = []
	for i in potential_answers:
		y_plot.append(fullobjective(i, lamb, X))
	return(y_plot)






################################################################################################################################




plt.figure(figsize=(4*2, 4), dpi = 600)



fw_y_plot = np.zeros(max_iter)
nofw_y_plot = np.zeros(max_iter)
fws_y_plot = np.zeros(max_iter)
cg_y_plot = np.zeros(max_iter)
mcg_y_plot = np.zeros(max_iter)
pga_y_plot = np.zeros(max_iter)


for i in range(no_of_times):


	rd_starting_pt = 0.1*rng.random(n1) + np.ones(n1)
	ones_starting_pt = np.ones(n1)
	starting_point_fw = rd_starting_pt
	starting_point_cg = ones_starting_pt
	starting_point_pga = rd_starting_pt

	X = np.random.standard_normal(size=(n1, n1))



	fw_y_plot += fwolfe1(1/fw_stepsize, qpobjective1, logconcaveobjective, starting_point_fw, lamb, X)
	nofw_y_plot += nofwolfe1(eps_for_nofw, qpobjective1, logconcaveobjective, starting_point_fw, lamb, X)
	fws_y_plot += fwolfesimple1(1/fws_stepsize, qpobjective1, logconcaveobjective, starting_point_fw, lamb, X)
	cg_y_plot += contgreedy1(1/cg_stepsize, qpobjective1, logconcaveobjective, starting_point_cg, lamb, X)
	mcg_y_plot += meascontgreedy1(1/mcg_stepsize, qpobjective1, logconcaveobjective, starting_point_cg, lamb, X)
	pga_y_plot += projga1(1/pga_stepsize, qpobjective1, logconcaveobjective, starting_point_pga, lamb, X)


fw_y_plot = fw_y_plot/no_of_times
nofw_y_plot = nofw_y_plot/no_of_times
fws_y_plot = fws_y_plot/no_of_times
cg_y_plot = cg_y_plot/no_of_times
mcg_y_plot = mcg_y_plot/no_of_times
pga_y_plot = pga_y_plot/no_of_times


max_nofw = max(nofw_y_plot)
max_nofw = [max_nofw] * len(x_plot)
max_nofw = np.array(max_nofw)


max_fw = max(fw_y_plot)
max_fw = [max_fw] * len(x_plot)
max_fw = np.array(max_fw)


print("Greedy FW (Algorithm 1):")
print(cg_y_plot[-1])
print("Non-oblivious FW (Algorithm 4):")
print(max_nofw[-1])
print("Measured Greedy FW (Algorithm 2):")
print(mcg_y_plot[-1])
print("Gradient Combining FW (Algorithm 3):")
print(max_fw[-1])
print("FW (baseline):")
print(fws_y_plot[-1])
print("Projected Gradient Ascent (baseline):")
print(pga_y_plot[-1])











