import numpy as np
import math
import scipy
from numpy import sqrt
import random as rd
from numpy.random import RandomState
from numpy.random import rand, randn
from scipy.linalg import qr
from dppy.finite_dpps import *
import matplotlib.pyplot as plt
from scipy.stats import unitary_group
from scipy.stats import ortho_group
import itertools
from scipy.optimize import minimize, LinearConstraint
from scipy.optimize import rosen
from scipy.optimize import linprog
import seaborn as sb
import time
import copy


################################################################################################################################
################################################################################################################################



#enter dimension below (n1)
n1 =  8

#enter number of constraints below (m1)				
m1 = 8				



################################################################################################################################
################################################################################################################################




no_of_times = 5
max_iter = 50
delta = 0.002
fw_stepsize = 50 
fws_stepsize = 50 
cg_stepsize = 50
mcg_stepsize = 50
pga_stepsize = 50
lamb = 0.5
eps_inv_for_nofw = 4
eps_for_nofw = 1/eps_inv_for_nofw
rng = np.random.default_rng() 
x_plot = list(range(1, max_iter+1))
b1 = np.ones(m1)



def qpobjective1(x, lamb, H1, h1, u1, A1, C1nsd):
	return(lamb*((np.transpose(x) @ H1 @ x)/2 + np.transpose(h1) @ x + 10))	


def logconcaveobjective(x, lamb, H1, h1, u1, A1, C1nsd):
	return((1-lamb)*0.1*-1*((np.transpose(x) @ C1nsd @ x)/2 ) + 10)	




def fullobjective(x, lamb, H1, h1, u1, A1, C1nsd):
	return(qpobjective1(x, lamb, H1, h1, u1, A1, C1nsd) + logconcaveobjective(x, lamb, H1, h1, u1, A1, C1nsd))




def basis(size, index):
	y = np.array([1.0 if i == index else 0.0 for i in range(size)])
	return(y)



def gradcal1(H, x, lamb, H1, h1, u1, A1, C1nsd): 		
	gradient = np.array([0.0 for i in range(n1)])
	for i in range(n1):
		p = (H(x + basis(n1, i)*delta, lamb, H1, h1, u1, A1, C1nsd) - H(x, lamb, H1, h1, u1, A1, C1nsd))/delta
		if p <= 0.5:
			gradient[i] = p
		elif p > 0.5:
			gradient[i] = (H(x, lamb, H1, h1, u1, A1, C1nsd) - H(x - basis(n1, i)*delta, lamb, H1, h1, u1, A1, C1nsd))/delta
	return(gradient)



def gradcal_auxiliaryG(x, H1, h1, u1, A1, C1nsd):
	gradient = np.array([0.0 for i in range(n1)])
	for j in range(1, eps_inv_for_nofw + 1):
		gradient = gradient + (((math.e)**(eps_for_nofw*j))*gradcal1(qpobjective1, (eps_for_nofw*j)*x, lamb, H1, h1, u1, A1, C1nsd))/(eps_for_nofw*j)

	gradient = eps_for_nofw*gradient
	return(gradient)






def fwolfe1(epsilon, qpobjective1, logconcaveobjective, y, lamb, H1, h1, u1, A1, C1nsd):			
	potential_answers = []
	it = 0
	while it < max_iter:
		p = gradcal1(qpobjective1, y, lamb, H1, h1, u1, A1, C1nsd)
		q = gradcal1(logconcaveobjective, y, lamb, H1, h1, u1, A1, C1nsd)
		r = p + 2*q
		c = np.array(r)
		c = -c
		bounds_arg = []
		for i in range(n1):
			bounds_arg.append((0,u1[i]))
		res = linprog(c, A_ub=A1, b_ub=b1, bounds = bounds_arg)
		x_ = res.x
		x_ = np.array(x_)
		y = np.array(y)
		y = (1 - epsilon)*y + epsilon*x_
		potential_answers.append(y)		
		it = it+1
	final_out = []
	for i in potential_answers:
		final_out.append(fullobjective(i, lamb, H1, h1, u1, A1, C1nsd))
	y_plot = final_out
	return(y_plot)






def nofwolfe1(epsilon, qpobjective1, logconcaveobjective, y, lamb, H1, h1, u1, A1, C1nsd):			
	potential_answers = []
	it = 0
	while it < max_iter:
		p = (1/math.e)*gradcal_auxiliaryG(y, H1, h1, u1, A1, C1nsd)
		q = gradcal1(logconcaveobjective, y, lamb, H1, h1, u1, A1, C1nsd)
		r = p + q
		c = np.array(r)
		c = -c
		bounds_arg = []
		for i in range(n1):
			bounds_arg.append((0,u1[i]))
		res = linprog(c, A_ub=A1, b_ub=b1, bounds = bounds_arg)
		x_ = res.x
		x_ = np.array(x_)
		y = np.array(y)
		y = (1 - epsilon)*y + epsilon*x_
		potential_answers.append(y)		
		it = it+1
	final_out = []
	for i in potential_answers:
		final_out.append(fullobjective(i, lamb, H1, h1, u1, A1, C1nsd))
	y_plot = final_out
	return(y_plot)





def fwolfesimple1(epsilon, qpobjective1, logconcaveobjective, y, lamb, H1, h1, u1, A1, C1nsd):			
	potential_answers = []
	it = 0
	while it < max_iter:
		p = gradcal1(qpobjective1, y, lamb, H1, h1, u1, A1, C1nsd)
		q = gradcal1(logconcaveobjective, y, lamb, H1, h1, u1, A1, C1nsd)
		r = p + q
		c = np.array(r)
		c = -c
		bounds_arg = []
		for i in range(n1):
			bounds_arg.append((0,u1[i]))
		res = linprog(c, A_ub=A1, b_ub=b1, bounds = bounds_arg)
		x_ = res.x
		x_ = np.array(x_)
		y = np.array(y)
		y = (1 - epsilon)*y + epsilon*x_
		potential_answers.append(y)		
		it = it+1
	final_out = []
	for i in potential_answers:
		final_out.append(fullobjective(i, lamb, H1, h1, u1, A1, C1nsd))
	y_plot = final_out
	return(y_plot)





def contgreedy1(epsilon, qpobjective1, logconcaveobjective, y, lamb, H1, h1, u1, A1, C1nsd):			
	potential_answers = []
	it = 0
	while it < max_iter:
		p = gradcal1(qpobjective1, y, lamb, H1, h1, u1, A1, C1nsd)
		q = gradcal1(logconcaveobjective, y, lamb, H1, h1, u1, A1, C1nsd)
		r = p + q
		c = np.array(r)
		c = -c
		bounds_arg = []
		for i in range(n1):
			bounds_arg.append((0,u1[i]))
		res = linprog(c, A_ub=A1, b_ub=b1, bounds = bounds_arg)
		x_ = res.x
		x_ = np.array(x_)
		y = np.array(y)
		y = y + epsilon*x_
		potential_answers.append(y)		
		it = it+1
	y_plot = []
	for i in potential_answers:
		y_plot.append(fullobjective(i, lamb, H1, h1, u1, A1, C1nsd))
	return(y_plot)



def meascontgreedy1(epsilon, qpobjective1, logconcaveobjective, y, lamb, H1, h1, u1, A1, C1nsd):			
	potential_answers = []
	it = 0
	while it < max_iter:
		p = gradcal1(qpobjective1, y, lamb, H1, h1, u1, A1, C1nsd)
		q = gradcal1(logconcaveobjective, y, lamb, H1, h1, u1, A1, C1nsd)
		r = np.multiply(np.ones(n1) - y, p+q)
		c = np.array(r)
		c = -c
		bounds_arg = []
		for i in range(n1):
			bounds_arg.append((0,u1[i]))
		res = linprog(c, A_ub=A1, b_ub=b1, bounds = bounds_arg)
		x_ = res.x
		x_ = np.array(x_)
		x_ = np.multiply(np.ones(n1) - y, x_)
		y = np.array(y)
		y = y + epsilon*x_
		potential_answers.append(y)		
		it = it+1
	y_plot = []
	for i in potential_answers:
		y_plot.append(fullobjective(i, lamb, H1, h1, u1, A1, C1nsd))
	return(y_plot)


def objective_function(x, potoutsidepoint):
	return(np.sum(np.power((x - potoutsidepoint), 2)))


def projga1(epsilon, qpobjective1, logconcaveobjective, y, lamb, H1, h1, u1, A1, C1nsd):
	potential_answers = []
	it = 0
	while it < max_iter:
		p = gradcal1(qpobjective1, y, lamb, H1, h1, u1, A1, C1nsd)
		q = gradcal1(logconcaveobjective, y, lamb, H1, h1, u1, A1, C1nsd)
		r = p + q
		y = np.array(y)
		y = y + epsilon*r
		ypga = np.array(y).tolist()
		bounds_arg = []

		for i in range(n1):
			bounds_arg.append((0, u1[i]))

		negativecons = [-np.inf for i in range(m1)]
		constraint = LinearConstraint(A1, negativecons, np.ones(m1))
		res = minimize(objective_function, x0 = ypga, args = (ypga,), constraints = constraint, bounds = bounds_arg)
		y = res.x
		potential_answers.append(np.array(y))		
		it = it+1

	y_plot = []
	for i in potential_answers:
		y_plot.append(fullobjective(i, lamb, H1, h1, u1, A1, C1nsd))
	return(y_plot)





plt.figure(figsize=(4*2, 4), dpi = 600)

fw_y_plot = np.zeros(max_iter)
nofw_y_plot = np.zeros(max_iter)
fws_y_plot = np.zeros(max_iter)
cg_y_plot = np.zeros(max_iter)
mcg_y_plot = np.zeros(max_iter)
pga_y_plot = np.zeros(max_iter)


for i in range(no_of_times):

	A1 = rng.random((m1, n1))
	A1 = A1 + np.full((m1,n1), 0.01)

	b1 = np.ones(m1)

	u1 = np.ones(n1)

	for j in range(n1):
		tightub = []
		for i in range(m1):
			tightub.append(1/A1[i][j])
		if m1 != 0:
			u1[j] = min(tightub)

	H1 = rng.random((n1, n1))
	H1 = H1 + np.full((n1,n1), -1.00)
	H1 = (H1 + np.transpose(H1))/2

	h1 = -0.2* (np.transpose(H1) @ u1)

	C1 = rng.random((n1, n1))
	C1nsd = np.dot(C1, C1.transpose())

	rd_starting_pt = 0.1*rng.random(n1)
	zero_starting_pt = np.zeros(n1)
	starting_point_fw = rd_starting_pt
	starting_point_cg = zero_starting_pt
	starting_point_pga = rd_starting_pt

	fw_y_plot += fwolfe1(1/fw_stepsize, qpobjective1, logconcaveobjective, starting_point_fw, lamb, H1, h1, u1, A1, C1nsd)
	nofw_y_plot += nofwolfe1(eps_for_nofw, qpobjective1, logconcaveobjective, starting_point_fw, lamb, H1, h1, u1, A1, C1nsd)
	fws_y_plot += fwolfesimple1(1/fws_stepsize, qpobjective1, logconcaveobjective, starting_point_fw, lamb, H1, h1, u1, A1, C1nsd)
	cg_y_plot += contgreedy1(1/cg_stepsize, qpobjective1, logconcaveobjective, starting_point_cg, lamb, H1, h1, u1, A1, C1nsd)
	mcg_y_plot += meascontgreedy1(1/mcg_stepsize, qpobjective1, logconcaveobjective, starting_point_cg, lamb, H1, h1, u1, A1, C1nsd)
	pga_y_plot += projga1(1/pga_stepsize, qpobjective1, logconcaveobjective, starting_point_pga, lamb, H1, h1, u1, A1, C1nsd)


fw_y_plot = fw_y_plot/no_of_times
nofw_y_plot = nofw_y_plot/no_of_times
fws_y_plot = fws_y_plot/no_of_times
cg_y_plot = cg_y_plot/no_of_times
mcg_y_plot = mcg_y_plot/no_of_times
pga_y_plot = pga_y_plot/no_of_times

max_nofw = max(nofw_y_plot)
max_nofw = [max_nofw] * len(x_plot)
max_nofw = np.array(max_nofw)

max_fw = max(fw_y_plot)
max_fw = [max_fw] * len(x_plot)
max_fw = np.array(max_fw)


plt.plot(x_plot, cg_y_plot, color = 'blue', label = 'Greedy FW (Algorithm 1)')
plt.plot(x_plot, mcg_y_plot, color = 'green', label = 'Measured Greedy FW (Algorithm 2)')
plt.plot(x_plot, max_fw, 'r--', label = 'Gradient Combining FW (Algorithm 3) Output', marker = "")
plt.plot(x_plot, max_nofw, 'm--', label = 'Non-oblivious FW (Algorithm 4) Output', marker = "")
plt.plot(x_plot, fws_y_plot, color = 'orange', label = 'FW (baseline)', marker = "")
plt.plot(x_plot, pga_y_plot, color = 'black', label = 'Projected Gradient Ascent (baseline)')


plt.ylabel('Function Value')
plt.xlabel('Number of Iterations')
plt.legend()
plt.savefig("quadraticprogramming_fig.png")











