'''
Script to compare data from MSB and ASB
'''

import json

asb_msb_dict = {
    'MonkeyG': {
        'day_09_02_24': {'anterior': [], 'posterior': list(range(16))},
        'day_12_02_24': {'anterior': [], 'posterior': list(range(16))},
        'day_23_02_24': {'anterior': list(range(15)), 'posterior': []},
        'day_27_02_24': {'anterior': list(range(16)), 'posterior': list(range(16, 32))},
        'day_29_02_24': {'anterior': list(range(14)), 'posterior': list(range(14, 30))},
        'day_01_03_24': {'anterior': list(range(14)), 'posterior': list(range(14, 29))},
        'day_05_03_24': {'anterior': list(range(15)), 'posterior': list(range(15, 31))},
        'day_06_03_24': {'anterior': [], 'posterior': list(range(16, 31)), 'excluded_by_blank': list(range(16))},
        'day_18_04_24': {'anterior': [], 'posterior': list(range(10))}
    },
    'MonkeyT': {
        'day_18_04_24': {'anterior': [], 'posterior': list(range(10))},
        'day_23_04_24': {'anterior': [], 'posterior': [1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15],
                         'excluded_by_blank': [0, 4, 5, 6]},
        'day_24_04_24': {'anterior': [], 'posterior': list(range(10))},
        'day_29_04_24': {'anterior': [], 'posterior': list(range(16))},
        'day_30_04_24': {'anterior': [], 'posterior': list(range(16))},
        'day_02_05_24': {'anterior': list(range(10)), 'posterior': list(range(10, 24))},
        'day_03_05_24': {'anterior': list(range(8)), 'posterior': list(range(8, 24))},
        'day_06_05_24': {'anterior': list(range(12)), 'posterior': list(range(12, 22))},
        'day_07_05_24': {'anterior': list(range(12)), 'posterior': list(range(12, 23))},
        'day_08_05_24': {'anterior': list(range(12)), 'posterior': list(range(12, 23))}
    }
}

# Serializing json
json_object = json.dumps(asb_msb_dict, indent=4)

# Writing to sample.json
with open(r"D:\Alex\SB\online_experiment\data_information\asb_msb_idx.json", "w") as outfile:
    outfile.write(json_object)

print('Wrote json to {}'.format(r"D:\Alex\SB\online_experiment\data_information\asb_msb_idx.json"))

