import json
import scipy.io
import numpy as np
from os.path import join

def load_config(config_path):
    with open(config_path, "r") as jsonfile:
        config = json.load(jsonfile)
    return config

def mat_to_numpy(directory, matlab_file_name, matrix_name=None):
    '''
    Casts MATLAB file from experimental partners to numpy and saves to same directory
    '''
    if matrix_name is None:
        matrix_name = matlab_file_name
    # Load MATLAB file
    mat = scipy.io.loadmat(join(directory, matlab_file_name))

    # Extract the matrix and convert it to a NumPy array
    names = [matrix_name, 'resp', 'respII_TopToBottom']
    for i in range(len(names)):
        print(names[i])
        try:
            numpy_array = np.array(mat[names[i]])
            break
        except:
            print('Could not find the matrix in the.mat file! Check the possible names.')
            pass

    spike_array_path = join(directory, matlab_file_name.replace('.mat', '.npy'))
    np.save(spike_array_path, numpy_array)

    return spike_array_path

def set_config(config, base_path):
    '''
    Set relative paths in the config file.
    '''
    config['base_path'] = base_path
    config['stimulus_path'] = join(base_path, 'submission_data/imgs/STIM_VPIXXscreen')
    config['resnet_weight_path'] = join(base_path, 'submission_data/resnet50_l2_eps0.1.ckpt')
    config['idx_path'] = join(base_path, 'evaluate/configs/online_idx.pickle')
    config['object_path'] = join(base_path, 'submission_data/imgs/final_stimuli_24_08_02/Object')
    config['body_path'] = join(base_path, 'submission_data/imgs/final_stimuli_24_08_02/Body')
    return config