'''
Calculate confidence intervals for correlations.
'''

import numpy as np
from scipy.stats import t, beta, pearsonr

def compute_conf_interval(n, alpha):
    '''
    Returns the upper bound of the confidence interval for the null hypothesis that the population correlation
    is zero. For consistency, this implementation yields confidence intervals which match the significance threshold
    when calling pearsonr().
    Args:
        n: Number of samples
        alpha: Significance level

    Returns: Upper bound of confidence interval around 0

    '''

    # under null hypothesis, estimator r follows a beta distribution
    dist = beta(n / 2 - 1, n / 2 - 1, loc=-1, scale=2)

    r = dist.ppf(alpha)

    return r
