There are 9 datasets in total:
```
system_administrator_1
system_administrator_2
tictactoe_vs_random
tiger_vs_antelope
csma_2_2
csma_2_4
firewire
wlan0
wlan1
```
Let use system_administrator_1 as an example.


#### Set the Iteration Number
To set the iteration number, use the following command:
For directly using the __optimizer__
```
julia +1.7 ./test/TPIO_naive.jl 3 0.99 CF+MILP+SG 42 sl system_administrator_1 1 0.01 1 CART exp
```
For using the __Reduced-Space Branching and bound Serially__
```
julia +1.7 ./test/TPIO_bb_new.jl 3 0.99 CF+MILP+SG 42 sl system_administrator_1 1 0.01 1 CART exp
``` 
For using the __Reduced-Space Branching and bound in Parallel__
```
mpiexec -n 10 julia +1.7 ./test/TPIO_bb_new.jl 3 0.99 CF+MILP+SG 42 par system_administrator_1 1 0.01 1 CART exp
```

#### Set Time Limit
To set a fixed time limit for the experiment, use the following command:
```
julia +1.7 ./test/TPIO_TL.jl 4 0.99 CF+MILP+SG 42 sl system_administrator_1 3600 0.005 1 OMDT linear
```




