import Pkg
Pkg.add("Gurobi")

ENV["GUROBI_HOME"] = "./gurobi1201/linux64"
using Pkg
Pkg.build("Gurobi")


using JuMP, Gurobi

model = Model(Gurobi.Optimizer)
@variable(model, x >= 0)
@variable(model, y >= 0)
@objective(model, Max, x + y)
@constraint(model, x + 2y <= 1)
optimize!(model)
value.(all_variables(model))
