# install_packages.jl

import Pkg

const pkgs = [
    # ("CPLEX",          v"0.9.3"),
    ("CSV",            v"0.10.4"),
    ("CategoricalArrays", v"0.10.6"),
    ("Clustering",     v"0.14.2"),
    ("DataFrames",     v"1.3.4"),
    ("DecisionTree",   v"0.10.12"),
    ("Distances",      v"0.10.7"),
    ("Distributions",  v"0.25.65"),
    ("JuMP",           v"1.1.1"),
    ("Luxor",          v"3.4.0"),
    ("MLDataUtils",    v"0.5.4"),
    ("MPI",            v"0.19.2"),
    ("Plots",          v"1.31.2"),
    ("RDatasets",      v"0.7.6"),
    ("StaticArrays",   v"1.5.1"),
    ("StatsBase",      v"0.33.18"),
    # 标准库无需安装，下面列出仅供参考
    ("NPZ",  nothing),
    ("TimerOutputs",         nothing),
    # ("Random",         nothing),
    # ("SparseArrays",   nothing),
    # ("Statistics",     nothing),
]

println("start installing Julia packages...")
for (name, version) in pkgs
    # println("→ 安装 $name@$version …")
    println("installing $name@$version...")
    Pkg.add(Pkg.PackageSpec(name=name, version=version))
end

println("all packages installed, resolving and instantiating...")
Pkg.resolve()
Pkg.instantiate()
println("Done.")
