module Nodes_rl

using Printf
using Trees, bound_rl, parallel

export Node

struct Node
    lower::Union{Nothing, Tree}
    upper::Union{Nothing, Tree}
    level::Int
    UB::Float64
    values::Union{Nothing, Vector{Float64}} # {-10000, values}  -10000: undetermined, values are value for sample i
    groups #::Union{Nothing, Vector{Vector{Int64}}}
    lambda
    group_trees::Union{Nothing, Tree, Vector{Tree}}
    UB_gp::Union{Nothing, Vector{Float64}}
    lrg_gap::Union{Nothing, Vector{Bool}}
    bch_var::String
end

# Node() = Node(nothing, nothing, -10000, 1e15, nothing, nothing, nothing, nothing, nothing, nothing, "d")
Node() = Node(nothing, nothing, -typemax(Float64), 1e15, nothing, nothing, nothing, nothing, nothing, nothing, "d")

function node_init()
    node = Node()
    return node
end

# function to print the node in a neat form
function printNodeList(nodeList)
    for i in eachindex(nodeList) #1:length(nodeList)
        println(map(x -> @sprintf("%.3f",x), getfield(nodeList[i],:lower))) # reserve 3 decimal precision
        println(map(x -> @sprintf("%.3f",x), getfield(nodeList[i],:upper)))
        println(getfield(nodeList[i],:level)) # integer
        println(map(x -> @sprintf("%.3f",x), getfield(nodeList[i],:LB)))
    end
end


end