from dataclasses import dataclass
from pathlib import Path
from typing import Optional


@dataclass
class TrainConfig:
    craft_type: str
    key_seed: Optional[int]
    key_len: int
    key_sentence: str
    value_seed: Optional[int]
    value_len: int
    value_sentence: str

    checkpoint: str

    init_seed: Optional[int]
    sampling_seed: Optional[int]
    n_seq: int
    seq_len: int
    initial_coeff: float
    mask_special_tokens: bool
    mask_key_tokens: bool
    mask_value_tokens: bool

    num_iter: int
    batch_size: int
    optimizer: str
    lr: float
    temperature: float
    p: float
    n_control: int

    device: str
    dtype: str
    output_dir: Path
