function [x,y,lambda]=convex_fill(w1,w2,rank_func)
% w1: weight 1
% w2: weight 2
% rank_func: rank oracle
% x: solution set
% y: weights of x
% lambda: trade-offs
l=[0,1];% Initial lambda
m=numel(w1);
total_points=[];lambda=[];
step=0;
while numel(l)>0
    points=zeros(2*numel(l),m+3);ind=1;% Initialized new points
    for i=1:numel(l)
        scalar_w=[1-l(i),l(i)]*[w1;w2];
        W1=[scalar_w',w1(:),w2(:)];
        W2=[scalar_w',w2(:),w1(:)];
        [~,I]=sortrows(W1);
        x1=greedy(I,rank_func);% Call to greedy
        [~,I]=sortrows(W2);
        x2=greedy(I,rank_func);% Call to greedy
        y11=sum(x1.*w1);y12=sum(x1.*w2);
        y21=sum(x2.*w1);y22=sum(x2.*w2);
        if y11<y21
            if y22<y12% If 2 separate points found, add both
                points(ind:(ind+1),:)=[y11,y12,1,x1;y21,y22,1,x2];
                ind=ind+2;
            else% Else, add non-dominated point
                points(ind,:)=[y11,y12,1,x1];
                ind=ind+1;
            end
        else
            points(ind,:)=[y21,y22,1,x2];
            ind=ind+1;
        end
    end
    points=sortrows([points(1:(ind-1),:);total_points],1:3);% Aggregate with old points
    distinct=true(size(points,1),1);
    distinct(2:end)=sum(abs(points(2:end,1:2)-points(1:(end-1),1:2)),2)>0;% Check for duplicates
    total_points=points(distinct,:);% Retain only non-duplicates, prioritize old points
    new_l=zeros(1,size(total_points,1)-1);indl=1;
    for i=2:size(total_points,1)
        if total_points(i-1,3)+total_points(i,3)-(step==0)==1% If exactly one endpoint is new, add lambda. Exception at step 0.
            numerator=abs(total_points(i,1)-total_points(i-1,1));
            denominator=abs(total_points(i-1,2)-total_points(i,2))+numerator;
            new_l(indl)=numerator/denominator;
            indl=indl+1;
        end
    end
    l=new_l(1:(indl-1));% Get next Lambda
    total_points(:,3)=0;% Set points to old
    step=step+1;
end
x=total_points(:,4:end);y=total_points(:,1:2);
lambda=zeros(1,size(y,1)-1);
for i=2:size(y,1)
    numerator=abs(total_points(i,1)-total_points(i-1,1));
    denominator=abs(total_points(i-1,2)-total_points(i,2))+numerator;
    lambda(i-1)=numerator/denominator;
end
end