function [A,w,G]=random_graph(n,m,k,weight_range,seed)
% n: number of vertices
% m: number of edges
% k: number of weights
% weight_range: value range for uniform sampling of weight values
% seed: self-explanatory
if nargin>=5
    rng(seed,'twister');
end
l=n*(n-1)/2;
x=false(1,l);x(randsample(l,m))=true;
w=randi(weight_range,k,m);
A=false(n,n);G=zeros(n,n);ind=1;indw=1;
for i=1:(n-1)
    for j=(i+1):n
        A(i,j)=x(ind);A(j,i)=x(ind);
        if x(ind);G(i,j)=w(indw);G(j,i)=w(1,indw);indw=indw+1;end
        ind=ind+1;
    end
end
end