clear all
% Select game:    
games = {'\textbf{Spoiled Child}',...
         '\textbf{AMPs}',...
         '\textbf{Stag Hunt}',...
         '\textbf{Battle of the Sexes}',...
         '\textbf{Pareto Coordination}',...
         '\textbf{Deadlock}',...
         '\textbf{Prisoner''s Dilemma}',...
         '\textbf{Chicken}',...
         '\textbf{Hawk-Dove}'};
game = games{2}(9:end-1);
aux_define_game;

% Select exploration policies:
policies = {'CLR-1', 'ETE'};
pol = {policies{1}, policies{2}};
aux_exploration_rates;

% Select dynamics: step is only relevant for
% continuous_approximation_step
dynamics = {'aux_discrete_batch', 'aux_discrete_step', 'aux_continuous_ode'};
step = 10;
n=2;
run(dynamics{2});

% Generate plots
main_game_surfaces;

filename=['C:\Users\sleon\Dropbox\Post\SUTD.Postdoc\Q_learning' ...
    '\Q_learning_continued\Matlab.files_qlearning\Figures\figure_' game '_' pol{1} '_' pol{2} '.png'];
%exportgraphics(fig2,['figure_spoiled_child_step_10000.png'],'BackgroundColor','white','Resolution','500')
%exportgraphics(fig2,filename,'BackgroundColor','white','Resolution','500')