set(groot,'defaultAxesTickLabelInterpreter','latex','defaulttextinterpreter','latex','defaultLegendInterpreter','latex');
clr   = [0.301 0.745 0.933]; %clr = [0.929 0.694 0.125]; %green 
clr   = [0 0.447 0.741]; %blue

% Figure 1: Exploration rates and probability of first action
fig1 = figure(1);
pos = get(fig1,'position');
set(fig1,'position',pos.*[0.8 1 2 0.6]);

subplot(1,2,1);
box on, grid on
hold all
plot(tplot,ybar-rates_y, 'Color', clr ,'LineWidth', 1.5);
plot(tplot,xbar-rates_x,'r','LineWidth', 1.5);
title('Exploration rates: $T_x,T_y$','FontSize', 14)

subplot(1,2,2);
box on 
grid on
hold all
p1 = plot(tplot,xplot,'r.','MarkerSize',3);
p2 = plot(tplot,yplot,'.','MarkerSize',3,'Color',clr);
p3 = plot(tplot(1),xplot(1),'r');
p4 = plot(tplot(1),yplot(1),'Color', clr);
legend([p3 p4], {'agent 1', 'agent 2'},'Location','best')
ylim([0 1]);
title('Probabilities of $H_1,H_2$','FontSize', 14)

% Figure 2: QRE surface and exploration path
fig2   = figure(2);
%myfun = @(d_x,d_y,u_x) k1.*(xbar-d_x).*exp(-log(exp(-k2.*(ybar-d_y).*(u_x-xmix))+1))-k1.*(xbar-d_x).*ymix+log(1-u_x)-log(u_x);
yq     = @(d_y,z) (1+exp(-(ybar-d_y).*[z,1-z]*B*[1;-1])).^(-1);
myfun2 = @(d_x,d_y,z) (xbar-d_x).*[1,-1]*A*[yq(d_y,z);1-yq(d_y,z)]+log(1-z)-log(z); %
fs     = fimplicit3(myfun2,[0 xbar 0 ybar L U],'MeshDensity',50);
% Properties of the figure
fs.EdgeColor       = 'none';
fs.AmbientStrength = 0.7;
fs.FaceAlpha       = 0.7;
fs.FaceColor       = [0.3010 0.7450 0.9330];
camlight(10,70);
%view([40 30]); 
view([-45 30]); 
zlim([0 1]); %view([-125 25]);
title([pol{1} ' vs ' pol{2}],'FontSize', 14)
xlabel('$T_x$');
ylabel('$T_y$');
zlabel('$P(H)$'); %fix_labels;

hold on
scatter3(xbar-rates_x,ybar-rates_y,xplot,8,tplot,'.')
orig1 = get(gca, 'Position');
% an = animatedline('Color', 'r', 'Linestyle', 'none', 'Marker', '.');
% dim1 = xbar-rates_x;
% dim2 = ybar-rates_y;
% dim3 = xplot;
% 
% for i = 1:length(dim1)
%     addpoints(an,dim1(i),dim2(i),dim3(i));
%     drawnow limitrate;
%     pause(0.0000001);
% end

% Colormap for Figure 2
map = copper;
map = flipud(map(40:end,:));
colormap(map);
cbr = colorbar('FontSize',8,'TickLabelInterpreter','latex','location','eastoutside','AxisLocation','in');
cbr.Label.String      = 'Iterations';
cbr.Label.FontSize    = 10;
cbr.Label.Interpreter = 'latex';

% Position of colorbar below Figure 2
cpos     = get(cbr,'Position');
set(cbr,'Position',[cpos(1)+0.117 cpos(2)*1.5 0.01 cpos(4)*0.85]);
orig1(2) = orig1(2)+0.05;
orig1(3) = orig1(3)*0.95;
orig1(4) = orig1(4)*0.95;
set(gca,'Position',orig1)

%exportgraphics(fig1,['figure_' pol{1} '_' pol{2} '.png'],'BackgroundColor','white','Resolution','1000')
%exportgraphics(fig2,['figure_main_' pol{1} '_' pol{2} '.png'],'BackgroundColor','white','Resolution','1000')