% Select game:    
games = {'\textbf{Spoiled Child}',...
         '\textbf{AMPs}',...
         '\textbf{Stag Hunt}',...
         '\textbf{Battle of the Sexes}',...
         '\textbf{Pareto Coordination}',...
         '\textbf{Deadlock}',...
         '\textbf{Prisoner''s Dilemma}',...
         '\textbf{Chicken}',...
         '\textbf{Hawk-Dove}'};
game = games{2}(9:end-1);
aux_define_game;

% Learning rates
ax = 0;
bx = 1;
ay = 0.05;
by = 1;

% Parameters for game/dynamics
n     = size(A,1);
step  = 0.0003;
z0    = [0.3 0.7 0.4 0.6];
tspan = [0 1000000];

rounds = tspan(end);
x      = ones(rounds,1)*0.5;
y      = ones(rounds,1)*0.5;
x(1)   = z0(1);
y(1)   = z0(3);

for t = 1:rounds-1
    x(t+1) = x(t) + step*x(t)*(1-x(t))*(bx*[1,-1]*A*[y(t);1-y(t)]-ax*(log(x(t))-log(1-x(t)))); 
    y(t+1) = y(t) + step*y(t)*(1-y(t))*(by*[x(t),1-x(t)]*B*[1;-1]-ay*(log(y(t))-log(1-y(t))));
end

z     = [x 1-x y 1-y];
xtraj = z(:,1);
ytraj = z(:,3);
tplot = (1:tspan(end))';

% Plots
set(groot,'defaultAxesTickLabelInterpreter','latex','defaulttextinterpreter','latex','defaultLegendInterpreter','latex');
fig1    = figure(1);
cline   = fun_color_line3(xtraj,ytraj,tplot,tplot,'LineStyle','-','LineWidth',2);
hold on
%scatter(xstar,ystar,3,'filled','r');

datatip(cline,'DataIndex',t(end), 'Location', 'northeast');
dtt                       = cline.DataTipTemplate;
dtt.DataTipRows(1).Label  = '$H_1:$';
dtt.DataTipRows(2).Label  = '$H_2:$';
dtt.DataTipRows(3).Label  = '$t:$';
dtt.Interpreter           = 'latex';
dtt.FontSize              = 18;
dtt.DataTipRows(1).Format = '%1.2g';
dtt.DataTipRows(2).Format = '%1.2g';
dtt.DataTipRows(3).Format = '%0.0g';

view(-30,45); %view(0,90);
grid on, box on
xlim([0 1]), ylim([0 1])
map = copper;
map = flipud(map(40:end,:));
colormap(map);
title(['$T_y = $ ' num2str(ay)],'FontSize', 22)
set(get(gca,'title'),'Position',[1.22 0.85 1.00011])
xlabel('$H_1$', 'Position',[0.5,-0.13,-190000],'Fontsize',20)
ylabel('$H_2$','Fontsize',20)
zlabel('Iterations','Fontsize',20)

% Position of colorbar right of Figure 2
cbr = colorbar('FontSize',8,'TickLabelInterpreter','latex','location','eastoutside','AxisLocation','in');
%cbr.Label.String      = 'Iterations';
%cbr.Label.FontSize    = 10;
cbr.Label.Interpreter = 'latex';
cpos     = get(cbr,'Position');
set(cbr,'Position',[cpos(1)+0.12 cpos(2) 0.01 cpos(4)]);
orig1    = get(gca, 'Position');
orig1(1) = orig1(1)-0.03;
set(gca,'Position',orig1);

gamet = lower(strrep(game,' ',''));
exaxt = strrep(num2str(ax),'.','');
exayt = strrep(num2str(ay),'.','');

%exportgraphics(fig1,['figure_' gamet '_' exaxt '_' exayt '.png'],'BackgroundColor','white','Resolution','500')
%exportgraphics(fig1,['figure_90' gamet '_' exaxt '.png'],'BackgroundColor','white','Resolution','500')