tic 
clear all
set(groot,'defaultAxesTickLabelInterpreter','latex','defaulttextinterpreter','latex','defaultLegendInterpreter','latex');

% A_prev = [-2 4; 1 -2];
% A_next = [2 -4; -1 2];
% A_frst = [-2; 1];
% A_last = [-4; 2];

% Payoff matrices
A_prev = [-1 1; 1 -1];
A_next = [1 -1; -1 1];
A_frst = [-1; 1];
A_last = [-1; 1];
ev     = @(k,n) [zeros(1,k-1) 1 zeros(1,n-k)];

N    = 3;               % Number of non-dummy players.
n    = 2;               % Number of actions.
iter = 100;             % Number of iterations.
eta  = 0.1;             % learning rates.        
etas = ones(1,N)*eta;   % learning rates.
T1   = 0:0.1:4;         % Temperature of p1.
T2   = 0:0.1:4;         % Temperature of p2.
T3   = 3;               % Temperature of p3.

% Initialize players' strategies
x0 = 0.5;
x  = [x0*ones(N,1,iter+1),(1-x0)*ones(N,1,iter+1)]; % Mixed strategies of all players.
for i = 1:N
    x0 = rand;
    x(i,:,1) = [x0, 1-x0];
end

% Find the QRE for each Temperature combination
plot_qre = zeros(length(T1),length(T2),N);

for i = 1:length(T1) 
    for j = 1:length(T2)
        as = [T1(i), T2(j), T3];
        plot_qre(i,j,:) = fun_compute_qre(as,N,n,etas,iter,x);
    end
end

% Find the KL-divergence for a different Temperature profile
for t = 4:4
    as = randi([t,4*t],1,N)/(5-t)^2;
    qre = fun_compute_qre(as,N,n,etas,iter,x);

    u = rand(1,N);
    v = rand(1,N);
    u = log(u./(1-u));
    v = log(v./(1-v));

    a = -5:0.5:5;
    b = a;

    la = length(a);
    lb = length(b);
    phi = zeros(la,lb);

    for i = 1:la;
        for j = 1:lb;
            tf = a(i)*u+b(j)*v;
            tf = exp(tf)./(exp(tf)+1);
            for k = 1:N
                phi(i,j) = phi(i,j) + qre(k)*log(qre(k)/tf(k))+(1-qre(k))*log((1-qre(k))/(1-tf(k)));
            end
        end
    end
end

% Plot QRE and Lyapunov surfaces

hfig = figure(1);
pos  = get(hfig,'position');
set(hfig,'position',pos.*[0 0.7 12 0.5]);
%sgtitle('QRE surfaces')

for k = 1:N
    plotq = squeeze(plot_qre(:,:,k));
    subplot(1,N+1,k);
    fs = surface(T1,T2,plotq);
    map = fun_inferno;
    map = map(50:end,:);
    colormap(map);
    grid on
    box on
    %fs(1).EdgeColor    = '#666666';
    fs(1).EdgeColor       = 'none';
    fs(1).AmbientStrength = 0.9;
    fs(1).FaceAlpha       = 0.9;
    fs(1).FaceColor       = [0.3010 0.7450 0.9330];
    view(-55,25)
    camlight(10,70);  
    xlabel('$T_2$');
    ylabel('$T_1$');
    zlabel('$\Pr(H)$');
    %title(['QRE Surface for player' num2str(k)]);  
end

subplot(1,N+1,N+1);
fs  = surfc(a,b,phi);
map = fun_inferno;
map = map(50:end,:);
colormap(map);
view([-55,25]);
box on
grid on
fs(1).EdgeColor = '#666666'; % 'none'
xlabel('$\alpha$');
ylabel('$\beta$');
zlabel('$D_{KL}(\mathbf{p}\|\mathbf{x})$');

%exportgraphics(hfig,'figure_line_network.png','BackgroundColor','white','Resolution','500')
toc