%Avoid numerical instabilities at 0 and 1.
epsilon = 1e-7;
L       = epsilon;
U       = 1-epsilon;

rounds = 40000;
inner  = 3e+10;
tplot  = 1:rounds;
iter   = 3e+2;

% X-player parameters;
min_x = 0.0001;
max_x = 7;
low_x = 0.000001;
end_x = 0.1*rounds;
top_x = 0.5;

% X-Policies: ETE, CLR-1
rates_ete_x = [linspace(max_x,min_x,rounds-end_x) linspace(min_x, low_x, end_x)];
rates_clr_x = [linspace(min_x,max_x,(rounds-end_x)*top_x) linspace(max_x,min_x,(rounds-end_x)*(1-top_x)) linspace(min_x, low_x, end_x)];

% Y-player parameters;
min_y = 0.0001;
max_y = 6;
low_y = 0.00001;
end_y = 0.1*rounds;
top_y = 0.7;

% Y-Policies: ETE, CLR-1
rates_ete_y = [linspace(max_y,min_y,rounds-end_y) linspace(min_y, low_y, end_y)];
rates_clr_y = [linspace(min_y,max_y,(rounds-end_y)*top_y) linspace(max_y,min_y,(rounds-end_y)*(1-top_y)) linspace(min_y, low_y, end_y)];

% Exploration-exploitation policy of agent x.
if strcmp(pol{1},'CLR-1')
    rates_x = rates_clr_x;
elseif strcmp(pol{1},'ETE')
    rates_x = rates_ete_x;
end

xbar    = max(rates_x);
%xbar    = 9;
rates_x = xbar-rates_x;
a_x     = 0.00001*ones(1,rounds);
b_x     = rates_x.*a_x;

% Exploration-exploitation policy of agent y.
if strcmp(pol{2},'CLR-1')
    rates_y = rates_clr_y;
elseif strcmp(pol{2},'ETE')
    rates_y = rates_ete_y;
end

ybar    = max(rates_y);
%ybar    = 6;
rates_y = ybar-rates_y;
a_y     = 0.0001*ones(1,rounds);
b_y     = rates_y.*a_y;