function dydt = qlearning_ode(t,z,A,B,ax,bx,ay,by,n)

% Here z = (x,y) where x is the choice distribution vector of the first player and y is
% the choice distribution vector of the second player. So, z(1:n) = x and
% z(n+1:2n) = y.
dydt = zeros(2*n,1); 
x    = z(1:n,1);
y    = z(n+1:2*n,1);
e    = @(k,n) [zeros(k-1,1);1;zeros(n-k,1)]; % unit vectors

for i = 1:n
    dydt(i) = z(i)*(bx*(e(i,n)-x)'*A*y-ax*(log(z(i))-x'*log(x)));
end

for i = n+1:2*n
    dydt(i) = z(i)*(by*x'*B*(e(i-n,n)-y)-ay*(log(z(i))-y'*log(y)));
end