tic
% Select game:    
games = {'\textbf{Rock-Paper-Scissors}',...     %1
         '\textbf{Mod-Rock-Paper-Scissors}',... %2
         '\textbf{4k}',...                      %3
         '\textbf{4k+}'};                       %4

game = games{1}(9:end-1);
ev   = @(k,n) [zeros(1,k-1) 1 zeros(1,n-k)];
aux_define_game;

tspan = [0 2000000];
tplot = (1:tspan(end))';
step  = 0.0003;
ax    = 0.01;
ay    = 0.01;
bx    = 1;
by    = 1;

eq    = fun_lemkehowson(A,B);
eqx   = eq{1}', eqy = eq{2}'
n     = size(A,1);
m     = size(A,2);
%z0    = [fun_randfixedsum(n,1,1,0.1,0.8)' fun_randfixedsum(m,1,1,0.1,0.8)'];
%z0(1:3) = [0.3 0.2 0.5];
%z0(1:3) = [1/3 1/3 1/3];
%z0 = zstor3;

rounds = tspan(end);
x      = ones(rounds,n)*(1/n);
y      = ones(rounds,m)*(1/m);
x(1,:) = z0(1:n);
y(1,:) = z0(n+1:n+m);

%Avoid numerical instabilities at 0 and 1.
epsilon = 1e-7;
L       = epsilon;
U       = 1-epsilon;

for t = 1:rounds-1
    xt = x(t,:);
    yt = y(t,:);    
    for i = 1:n
        x(t+1,i) = xt(i) + step*xt(i)*(bx*(ev(i,n)-xt)*A*yt'-ax*(log(xt(i))-xt*log(xt)'));
    end
    for j = 1:m
        y(t+1,j) = yt(j) + step*yt(j)*(by*xt*B*(ev(j,m)-yt)'-ay*(log(yt(j))-yt*log(yt)'));
    end
end

%xlast = x(end,:)
%ylast = y(end,:)

% Plots
set(groot,'defaultAxesTickLabelInterpreter','latex','defaulttextinterpreter','latex','defaultLegendInterpreter','latex');
figx   = figure(1);
clinex = fun_color_line3(x(:,1),x(:,2),x(:,3),tplot,'LineStyle','-','LineWidth',2);
hold on
scatter3(eqx(1), eqx(2), eqx(3), 12,'filled','b');

view(0,90);
grid on, box on
xlim([0 1]), ylim([0 1])
map = copper;
map = flipud(map(40:end,:));
colormap(map);
%title([ game ': $T_x = $ ' num2str(ax)  ' , $T_y = $ ' num2str(ay)],'FontSize', 10)
title([' $T_y = $ ' num2str(ay)],'FontSize', 16, 'Position',[0.75, 0.7, 0.32])
xlabel('Rock','FontSize',16)
ylabel('Paper','FontSize',16)
zlabel('Scissors','FontSize',16)
filename=['C:\Users\sleon\Dropbox\Post\SUTD.Postdoc\Q_learning' ...
    '\Q_learning_continued\Matlab.files_qlearning\Figures\figure_rps_x_' num2str(ay) '.png'];
%exportgraphics(figx,filename,'BackgroundColor','white','Resolution','500')

figy   = figure(2);
cliney = fun_color_line3(y(:,1),y(:,2),y(:,3),tplot,'LineStyle','-','LineWidth',2);
hold on
scatter3(eqy(1), eqy(2), eqy(3), 12,'filled','b');

view(0,90);
grid on, box on
xlim([0 1]), ylim([0 1])
map = copper;
map = flipud(map(40:end,:));
colormap(map);
%title([ game ': $T_x = $ ' num2str(ax)  ' , $T_y = $ ' num2str(ay)],'FontSize', 10)
title([' $T_y = $ ' num2str(ay)],'FontSize', 16, 'Position',[0.75, 0.7, 0.32])
xlabel('Rock','FontSize',16)
ylabel('Paper','FontSize',16)
zlabel('Scissors','FontSize',16)
filename=['C:\Users\sleon\Dropbox\Post\SUTD.Postdoc\Q_learning' ...
    '\Q_learning_continued\Matlab.files_qlearning\Figures\figure_rps_y_' num2str(ay) '.png'];
%exportgraphics(figy,filename,'BackgroundColor','white','Resolution','500')
toc



% Position of colorbar right of fig1
% cbr                   = colorbar('FontSize',8,'TickLabelInterpreter','latex','location','eastoutside','AxisLocation','in');
% cbr.Label.String      = 'Iterations';
% cbr.Label.FontSize    = 10;
% cbr.Label.Interpreter = 'latex';
% cpos                  = get(cbr,'Position');
% set(cbr,'Position',[cpos(1)+0.12 cpos(2) 0.01 cpos(4)]);
% orig1                 = get(gca, 'Position');
% orig1(1)              = orig1(1)-0.03;
% set(gca,'Position',orig1);

% gamet = lower(strrep(game,' ',''));
% exaxt = strrep(num2str(ax),'.','');
% exayt = strrep(num2str(ay),'.','');
% 
% hfig = figure(2);
% pos  = get(hfig,'position');
% set(hfig,'position',pos.*[0 1 4 1]);
% subplot(1,2,1)
% plot(x)
% subplot(1,2,2)
% plot(y)
%exportgraphics(fig1,['figure_' gamet '_' exaxt '_' exayt '.png'],'BackgroundColor','white','Resolution','500')
%exportgraphics(fig1,['figure_90' gamet '_' exaxt '.png'],'BackgroundColor','white','Resolution','500')