# Contribution Guidelines

Thank you for considering contributing to OG-MARL! We love welcoming contributions from fellow
researchers. There are several ways to contribute to the library, e.g. raising issues, writing
documentation and code. This guide will help you in that process.

To contribute a feature to OG-MARL, one needs to fork the repository, implement the feature there,
and then open a PR from the fork to the main repository.

## Pull Request Checklist

Before sending your pull requests, make sure you do the following:
- Read the [Contributing Guidelines](#Contributing-Code).
- Read the [Code of Conduct](#Code-of-Conduct).
- Ensure you have signed the [Contributor License Agreement](#Contributor-License-Agreement) (CLA).
- Check if your changes are consistent with the [Guidelines](#General-guidelines-and-philosophy-for-contribution) and the [Coding Style](#Coding-Style).

## Contributing Code

All submissions, including submissions by project members, require review.
We use GitHub pull requests for this purpose.
Consult [GitHub Help](https://docs.github.com/en/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests)
for more information on using pull requests.

Before sending your pull request for review, make sure your changes are consistent with the guidelines and follow the coding style and code of conduct.

### General guidelines and philosophy for contribution
- When you contribute a new feature to OG-MARL, the maintenance burden is (by default) transferred to the OG-MARL team. This means that the benefit of the contribution must be compared against the cost of maintaining the feature.
- Keep API compatibility in mind when you change code. Non-backward-compatible API changes will not be made if they don't greatly improve the library.

### Coding Style
In general, we follow the [Google Style Guide](https://google.github.io/styleguide/pyguide.html).
We use [conventional commit messages](https://www.conventionalcommits.org/en/v1.0.0/) for commit messages.

### Code of Conduct
We ask you to help us develop a positive working environment. Behaviours that contribute to it include:

* Using welcoming and inclusive language
* Being respectful of differing viewpoints and experiences
* Gracefully accepting constructive criticism
* Focusing on what is best for the community
* Showing empathy towards other community members

### Testing
Please make sure that you do sufficent testing of your new feature and provide evidence in your PR.

### Contributor License Agreement
Contributions to this project must be accompanied by a Contributor License Agreement.
You (or your employer) retain the copyright to your contribution, this simply gives us permission to use and
redistribute your contributions as part of the project. Head over to https://cla.developers.google.com/ to
see your current agreements on file or to sign a new one.

You generally only need to submit a CLA once, so if you've already submitted one
(even if it was for a different project), you probably don't need to do it again.
