DATA_ROOT=../datasets

train_alg=dagger

obj_features=vitbase
obj_ft_dim=768

ngpus=1
bs=16
seed=0

flag="--root_dir ${DATA_ROOT}
      --dataset r4r
      --world_size ${ngpus}
      --seed ${seed}
      --tokenizer bert      

      --enc_full_graph
      --graph_sprels
      --fusion dynamic

      --expert_policy ndtw
      --train_alg ${train_alg}
      
      --num_l_layers 9
      --num_x_layers 4
      --num_pano_layers 2
      
      --max_action_len 25
      --max_instr_len 200

      --batch_size ${bs}
      --lr 1e-5
      --iters 200000
      --log_every 5

      --optim adamW
      --angle_feat_size 4

      --feat_dropout 0.4
      --dropout 0.5
      --env_aug
      
      --gamma 0.
      "

(
features=internvit_6b_fov60
ft_dim=3200
ml_weight=0.8
# save=false
outdir=${DATA_ROOT}/R2R/exprs_map/finetune_r4r/loop3_best

CUDA_VISIBLE_DEVICES=5 python -u r2r/main_nav.py $flag \
    --output_dir ${outdir} \
    --tokenizer bert \
    --bert_ckpt_file ..datasets/R2R/exprs_map/pretrain_mantis/best_pt_model \
    --features ${features} \
    --image_feat_size ${ft_dim} \
    --log_every 500 \
    --expert_policy gtpg \
    --ml_weight ${ml_weight} \
    --save $save
) &

wait