DATA_ROOT=../datasets

train_alg=dagger

features=internvit_6b_fov60
ft_dim=3200
obj_features=vitbase
obj_ft_dim=768

ngpus=1
bs=16
seed=0
iter=150

name=${train_alg}-${features}
name=${name}-seed.${seed}
name=${name}-"rvr_tune"


outdir=${DATA_ROOT}/REVERIE/exprs_map/finetune/${name}-aug.none
flag="--root_dir ${DATA_ROOT}
      --dataset reverie
      --output_dir ${outdir}
      --world_size ${ngpus}
      --seed ${seed}
      --tokenizer bert      

      --enc_full_graph
      --graph_sprels
      --fusion dynamic

      --expert_policy spl
      --train_alg ${train_alg}
      
      --num_l_layers 9
      --num_x_layers 4
      --num_pano_layers 2
      
      --max_action_len 15
      --max_instr_len 200

      --batch_size ${bs}
      --lr 1e-5
      --iters 200000
      --log_every 500

      --optim adamW

      --features ${features}
      --image_feat_size ${ft_dim}
      --angle_feat_size 4

      --ml_weight 0.15

      --feat_dropout 0.4
      --dropout 0.5
      
      --gamma 0."


# train
CUDA_VISIBLE_DEVICES=0 python reverie_nav/main_nav.py $flag  \
      --tokenizer bert \
      --bert_ckpt_file "../datasets/R2R/exprs_map/pretrain_mantis/best_pt_model \
      --eval_first