DATA_ROOT=../datasets

train_alg=dagger

obj_features=vitbase
obj_ft_dim=768

ngpus=1
bs=16
seed=0
ml_weight=0.5

flag="--root_dir ${DATA_ROOT}
      --dataset rxr
      --world_size ${ngpus}
      --seed ${seed}
      --tokenizer bert      

      --enc_full_graph
      --graph_sprels
      --fusion dynamic

      --expert_policy ndtw
      --train_alg ${train_alg}
      
      --num_l_layers 9
      --num_x_layers 4
      --num_pano_layers 2
      
      --max_action_len 20
      --max_instr_len 350

      --batch_size ${bs}
      --lr 1e-5
      --iters 200000
      --log_every 500

      --optim adamW
      --angle_feat_size 4

      --feat_dropout 0.4
      --dropout 0.5
      --env_aug
      
      --gamma 0.
      "

(
ml_weight=0.8
features=internvit_6b_fov60
ft_dim=3200
ft_augname='marky'
ft_augtime=2

save=false
outdir=${DATA_ROOT}/RxR/exprs_map/finetune/loop3_best

CUDA_VISIBLE_DEVICES=6 python -u r2r/main_nav.py $flag \
    --output_dir ${outdir} \
    --tokenizer bert \
    --bert_ckpt_file ..datasets/R2R/exprs_map/pretrain_mantis/best_pt_model \
    --features ${features} \
    --image_feat_size ${ft_dim} \
    --aug ../datasets/RxR/annotations/RXR_${ft_augname}_enc.json \
    --aug_times $ft_augtime \
    --log_every 600 \
    --expert_policy gtpg \
    --save $save \
    --ml_weight ${ml_weight}
) &

wait