DATA_ROOT=../datasets

train_alg=dagger

obj_features=vitbase
obj_ft_dim=768

ngpus=8
bs=16
seed=0

flag="--root_dir ${DATA_ROOT}
      --dataset r2r
      --world_size ${ngpus}
      --seed ${seed}
      --tokenizer bert      

      --enc_full_graph
      --graph_sprels
      --fusion dynamic

      --expert_policy spl
      --train_alg ${train_alg}
      
      --num_l_layers 9
      --num_x_layers 4
      --num_pano_layers 2
      
      --max_action_len 15
      --max_instr_len 200

      --batch_size ${bs}
      --lr 1e-5
      --iters 200000
      --log_every 500

      --optim adamW
      --angle_feat_size 4

      --ml_weight 0.15

      --feat_dropout 0.4
      --dropout 0.5
      
      --gamma 0.
      
      --fp16"

features=internvit_6b
# features=internvit_6b_fov60
ft_dim=3200

# sleep 14400
for split in hm3d_loop3
do
      CUDA_VISIBLE_DEVICES='0,1,2,3,4,5,6,7' python -m torch.distributed.launch \
            --use_env \
            --master_port 4112 \
            --nproc_per_node=${ngpus} --node_rank 0 \
            r2r/main_nav.py $flag \
            --output_dir ..datasets/R2R/exprs_map/finetune/best_loop3_pretrain/preds \
            --tokenizer bert \
            --resume_file  ../datasets/R2R/exprs_map/finetune/best_loop3_pretrain/ckpts/best_val_unseen \
            --features ${features} \
            --image_feat_size ${ft_dim} \
            --test \
            --test_aug --test_aug_split  $split 
done

