DATA_ROOT=../datasets

train_alg=dagger

obj_features=vitbase
obj_ft_dim=768

ngpus=1
bs=16
seed=0

flag="--root_dir ${DATA_ROOT}
      --dataset r2r
      --world_size ${ngpus}
      --seed ${seed}
      --tokenizer bert      

      --enc_full_graph
      --graph_sprels
      --fusion dynamic

      --expert_policy spl
      --train_alg ${train_alg}
      
      --num_l_layers 9
      --num_x_layers 4
      --num_pano_layers 2
      
      --max_action_len 15
      --max_instr_len 200

      --batch_size ${bs}
      --lr 1e-5
      --iters 200000
      --log_every 500

      --optim adamW
      --angle_feat_size 4

      --ml_weight 0.15

      --feat_dropout 0.4
      --dropout 0.5
      --env_aug
      
      --gamma 0.
      
      --fp16"


ft_augname='final_greedy'

features=internvit_6b
pt_dir_ft_name=internvit.6b
ft_dim=3200

name=${train_alg}-${features}
name=${name}-seed.${seed}

inits=(170)
gpus=(4)
sleep_times=(0)

ft_augtime=19

name=${train_alg}-${features}
name=${name}-seed.${seed}


for i in "${!inits[@]}"
do
  init=${inits[$i]}
  gpu=${gpus[$i]}

  outdir=${DATA_ROOT}/R2R/exprs_map/finetune/${name}-loop3_pretrain.${init}k-final-ft
  
  echo "FT_AUG_NAME $ft_augname
  FT_AUG_TIME $ft_augtime
  INIT ${init}000
  OUTPUT_DIR $outdir"

  CUDA_VISIBLE_DEVICES=$gpu python r2r/main_nav.py $flag \
      --output_dir ${outdir} \
      --tokenizer bert \
      --bert_ckpt_file ../datasets/R2R/exprs_map/pretrain_mantis/best_pt_model \
      --features ${features} \
      --image_feat_size ${ft_dim} \
      --aug ../datasets/R2R/annotations/R2R_${ft_augname}_enc.json \
      --aug_times $ft_augtime \
      &
done

wait