# Copyright (c) Microsoft Corporation.
# Licensed under the MIT License.


from torchvision import transforms
import numpy as np


def act_train():
    return transforms.Compose([
        transforms.ToTensor()
    ])


def loaddata_from_numpy(dataset='DSADS', task='cross_people', root_dir='./data/act/'):
    x = np.load(root_dir+dataset+'/'+dataset.lower()+'_x.npy', allow_pickle=True)
    ty = np.load(root_dir+dataset+'/'+dataset.lower()+'_y.npy', allow_pickle=True)
    cy, py, sy = ty[:, 0], ty[:, 1], ty[:, 2] # class, person, sensor
    return x, cy, py, sy
