import numpy as np
import matplotlib.pyplot as plt
import math

# Function to calculate the logarithm of double factorial using logarithmic identities
def ori_log_double_factorial(n):
    if n <= 0:
        return 0
    else:
        return math.log(n) + ori_log_double_factorial(n - 2)

# Define the function f(x) using the logarithmic version to avoid overflow
def second_log(x, alpha):
    return (2 * x + 1) * math.log(np.sqrt(np.pi)) + ori_log_double_factorial(x - 1) - (2 * x + 1) * math.log(2) - (x + 1) * math.log(math.sqrt(alpha))

plt.figure(figsize=(6, 4))
# Generate x values (only even integers for x!! definition)
x_values = np.arange(1, 100, 1)  # Extend to large even x values
alpha = np.arange(1, 21, 1)
for i in range(len(alpha)):
    a = alpha[i]
    y_values_log = [second_log(x, a) for x in x_values]
    plt.plot(x_values, y_values_log, marker='o', linestyle='-', linewidth=1, label='$\gamma$ = {}'.format(a), color=plt.cm.tab20(i))

# Add red dashed lines and shaded area for the range 20 to 40
plt.axvline(20, color='red', linestyle='--', linewidth=3)
plt.axvline(40, color='red', linestyle='--', linewidth=3)
y_min = np.min([min([second_log(x, a) for x in x_values]) for a in alpha])
y_max = np.max([max([second_log(x, a) for x in x_values]) for a in alpha])

plt.fill_between(x_values, -25, 160, where=(x_values >= 20) & (x_values <= 40), color='red', alpha=0.5)
plt.ylim(-25, 160)
# plt.title(r'Plot of $\frac{\sqrt{\pi}^{2n+1} n !!}{2^{2n+1} \sqrt{\gamma}^{n+1}}$ for $n$', fontsize=14)
plt.xlabel("n", fontsize=14)
plt.ylabel(r'$\log \frac{\sqrt{\pi}^{2n+1} n !!}{2^{2n+1} \sqrt{\gamma}^{n+1}}$', fontsize=14)
plt.grid(True)

# Move legend outside of the plot
plt.legend(loc='upper left', ncol=4) #bbox_to_anchor=(1.2, 1), borderaxespad=0.)
# plt.text(50, -33, '50', color='red', fontsize=10, ha='center', fontweight='bold')

plt.tight_layout()  # Adjust layout to make space for legend
plt.savefig('double_factorial_plot.pdf')
