import os
import torch
from models import Transformer, FEDNet, PatchTST, Autoformer, FreTS, FEDNet_wo_det, FEDNet_wo_sto, FEDNet_wo_con, FEDNet_fc, FEDNet_fc_contrastive, GILE, FEDNet_v2, FEDNet_v1, Dlinear, TimesNet, iTransformer, FEDformer


class Exp_Basic(object):
    def __init__(self, args):
        self.args = args
        self.model_dict = {
            'Transformer': Transformer,
            'FEDNet': FEDNet,
            'PatchTST': PatchTST,
            'Autoformer': Autoformer,
            'FreTS': FreTS,
            'GILE': GILE,
            'FEDNet_wo_det': FEDNet_wo_det,
            'FEDNet_wo_sto': FEDNet_wo_sto,
            'FEDNet_wo_con': FEDNet_wo_con,
            'FEDNet_fc': FEDNet_fc,
            'FEDNet_fc_contrastive': FEDNet_fc_contrastive,
            'FEDNet_v1': FEDNet_v1,
            'FEDNet_v2': FEDNet_v2,
            'Dlinear': Dlinear,
            'TimesNet': TimesNet,
            'iTransformer': iTransformer,
            'FEDformer': FEDformer,
        }
        self.device = self._acquire_device()
        self.model = self._build_model().to(self.device)

    def _build_model(self):
        raise NotImplementedError
        return None

    def _acquire_device(self):
        if self.args.use_gpu:
            os.environ["CUDA_VISIBLE_DEVICES"] = str(
                self.args.gpu) if not self.args.use_multi_gpu else self.args.devices
            device = torch.device('cuda:{}'.format(self.args.gpu))
            print('Use GPU: cuda:{}'.format(self.args.gpu))
        else:
            device = torch.device('cpu')
            print('Use CPU')
        return device

    def _get_data(self):
        pass

    def vali(self):
        pass

    def train(self):
        pass

    def test(self):
        pass
