def DSADS_CROSSPOSITION_model(model_name):
    """ CAP model hparam definition """
    model_hparams = {
        'FEDNet': {
            'model': 'FEDNet',
            'hidden_size': 50,
            'fc_dim': 512,
            'kernel_size': 9,
            'normalize': True,
            'beta_d': 1.0,
            'beta_y': 1.0,
            'weight_true': 1000.0,
            'weight_false': 1000.0,
            'aux_loss_multiplier_y': 1000.0,
            'aux_loss_multiplier_d':1000.0,
            'patch_len': 16,
            'stride': 8,
            'd_model': 512,
            'factor': 1,
            'd_ff': 2048,
            'n_heads': 8,
            'output_attention': False,
            'activation': 'relu',
            'e_layers': 2,
            'd_layers': 1,
            'dropout': 0.5,
            'w_det': 1.0,
            'w_sto': 0.01,
        },
        'ActNetwork': {
            'model': 'ActNetwork',
            'ker_size': 6,
            'fc_size': 32*27,
            'classifier_type': 'linear'
        },
        'AdaRNN': {
            'model': 'AdaRNN',
            'use_bottleneck': False,
            'bottleneck_width': 256,
            'n_hiddens': [64,64],
            'dropout': 0.5,
            'model_type': 'AdaRNN',
            'trans_loss': 'mmd',
        },
        'GILE': {
            'model': 'GILE',
            'fc_dim': 512,
            'd_AE': 50,
            'beta_d': 1.0,
            'beta_y': 1.0,
            'weight_true': 1000.0,
            'weight_false': 1000.0,
            'aux_loss_multiplier_y': 1000.0,
            'aux_loss_multiplier_d':1000.0,
            'kernel_size': 9,
        },
        'FEDNet_wo_con': {
            'model': 'FEDNet_wo_con',
            'hidden_size': 50,
            'fc_dim': 512,
            'kernel_size': 9,
            'normalize': True,
            'beta_d': 1.0,
            'beta_y': 1.0,
            'weight_true': 1000.0,
            'weight_false': 1000.0,
            'aux_loss_multiplier_y': 1000.0,
            'aux_loss_multiplier_d':1000.0,
            'patch_len': 16,
            'stride': 8,
            'd_model': 512,
            'factor': 1,
            'd_ff': 2048,
            'n_heads': 8,
            'output_attention': False,
            'activation': 'relu',
            'e_layers': 2,
            'd_layers': 1,
            'dropout': 0.5,
            'w_det': 1.0,
            'w_sto': 0.01,
        },
        'FEDNet_wo_sto': {
            'model': 'FEDNet_wo_sto',
            'hidden_size': 50,
            'fc_dim': 512,
            'kernel_size': 9,
            'normalize': True,
            'beta_d': 1.0,
            'beta_y': 1.0,
            'weight_true': 1000.0,
            'weight_false': 1000.0,
            'aux_loss_multiplier_y': 1000.0,
            'aux_loss_multiplier_d':1000.0,
            'patch_len': 16,
            'stride': 8,
            'd_model': 512,
            'factor': 1,
            'd_ff': 2048,
            'n_heads': 8,
            'output_attention': False,
            'activation': 'relu',
            'e_layers': 2,
            'd_layers': 1,
            'dropout': 0.5,
            'w_det': 1.0,
            'w_sto': 0.01,
        },
        'FEDNet_wo_det': {
            'model': 'FEDNet_wo_det',
            'hidden_size': 50,
            'fc_dim': 512,
            'kernel_size': 9,
            'normalize': True,
            'beta_d': 1.0,
            'beta_y': 1.0,
            'weight_true': 1000.0,
            'weight_false': 1000.0,
            'aux_loss_multiplier_y': 1000.0,
            'aux_loss_multiplier_d':1000.0,
            'patch_len': 16,
            'stride': 8,
            'd_model': 512,
            'factor': 1,
            'd_ff': 2048,
            'n_heads': 8,
            'output_attention': False,
            'activation': 'relu',
            'e_layers': 2,
            'd_layers': 1,
            'dropout': 0.5,
            'w_det': 1.0,
            'w_sto': 0.01,
        },
    }

    return model_hparams[model_name]