def HHAR_model(model_name):
    """ HHAR model hparam definition """
    model_hparams = {
        'deep4': {
            'model': 'deep4',
            'feat_dim': 256, # make a record for IIB
        },
        'deep4_Freq': {
            'model': 'deep4_Freq',
            'feat_dim': 256, # make a record for IIB
        },
        'FreTS': {
            'model': 'FreTS'
        },
        'PatchTST': {
            'model': 'PatchTST'
        },
        'FEDNet': {
            'model': 'FEDNet',
            'hidden_size': 50,
            'fc_dim': 1984,
            'kernel_size': 9,
            'normalize': False,
            'beta_d': 1.0,
            'beta_y': 1.0,
            'weight_true': 1000.0,
            'weight_false': 1000.0,
            'aux_loss_multiplier_y': 1000.0,
            'aux_loss_multiplier_d':1000.0,
            'patch_len': 16,
            'stride': 8,
            'd_model': 512,
            'factor': 1,
            'd_ff': 2048,
            'n_heads': 8,
            'output_attention': False,
            'activation': 'relu',
            'e_layers': 2,
            'd_layers': 1,
            'dropout': 0.5,
            'alpha': 0.1,
            'w_det': 1.0,
            'w_sto': 0.001,
            'temperature': 0.07,
            'constraint_type': 'contrast',
            'freq_type': 'fft'
        },
        'AdaRNN': {
            'model': 'AdaRNN',
            'use_bottleneck': False,
            'bottleneck_width': 256,
            'n_hiddens': [64,64],
            'dropout': 0.5,
            'model_type': 'AdaRNN',
            'trans_loss': 'mmd',
        },
        'GILE': {
            'model': 'GILE',
            'fc_dim': 1984,
            'd_AE': 50,
            'beta_d': 1.0,
            'beta_y': 1.0,
            'weight_true': 1000.0,
            'weight_false': 1000.0,
            'aux_loss_multiplier_y': 1000.0,
            'aux_loss_multiplier_d':1000.0,
            'kernel_size': 9,
        },
        'FEDNet_wo_con': {
            'model': 'FEDNet_wo_con',
            'hidden_size': 50,
            'fc_dim': 1984,
            'kernel_size': 9,
            'normalize': False,
            'beta_d': 1.0,
            'beta_y': 1.0,
            'weight_true': 1000.0,
            'weight_false': 1000.0,
            'aux_loss_multiplier_y': 1000.0,
            'aux_loss_multiplier_d':1000.0,
            'patch_len': 16,
            'stride': 8,
            'd_model': 512,
            'factor': 1,
            'd_ff': 2048,
            'n_heads': 8,
            'output_attention': False,
            'activation': 'relu',
            'e_layers': 2,
            'd_layers': 1,
            'dropout': 0.5,
            'alpha': 0.1,
            'w_det': 1.0,
            'w_sto': 0.001,
        },
        'FEDNet_wo_sto': {
            'model': 'FEDNet_wo_sto',
            'hidden_size': 50,
            'fc_dim': 1984,
            'kernel_size': 9,
            'normalize': False,
            'beta_d': 1.0,
            'beta_y': 1.0,
            'weight_true': 1000.0,
            'weight_false': 1000.0,
            'aux_loss_multiplier_y': 1000.0,
            'aux_loss_multiplier_d':1000.0,
            'patch_len': 16,
            'stride': 8,
            'd_model': 512,
            'factor': 1,
            'd_ff': 2048,
            'n_heads': 8,
            'output_attention': False,
            'activation': 'relu',
            'e_layers': 2,
            'd_layers': 1,
            'dropout': 0.5,
            'alpha': 0.1,
            'w_det': 1.0,
            'w_sto': 0.001,
        },
        'FEDNet_wo_det': {
            'model': 'FEDNet_wo_det',
            'hidden_size': 50,
            'fc_dim': 1984,
            'kernel_size': 9,
            'normalize': False,
            'beta_d': 1.0,
            'beta_y': 1.0,
            'weight_true': 1000.0,
            'weight_false': 1000.0,
            'aux_loss_multiplier_y': 1000.0,
            'aux_loss_multiplier_d':1000.0,
            'patch_len': 16,
            'stride': 8,
            'd_model': 512,
            'factor': 1,
            'd_ff': 2048,
            'n_heads': 8,
            'output_attention': False,
            'activation': 'relu',
            'e_layers': 2,
            'd_layers': 1,
            'dropout': 0.5,
            'alpha': 0.1,
            'w_det': 1.0,
            'w_sto': 0.001,
        },
        'FEDNet_fc': {
            'model': 'FEDNet_fc',
            'hidden_size': 128,
            'fc_dim': 1984,
            'kernel_size': 9,
            'normalize': False,
            'beta_d': 1.0,
            'beta_y': 1.0,
            'weight_true': 1000.0,
            'weight_false': 1000.0,
            'aux_loss_multiplier_y': 1000.0,
            'aux_loss_multiplier_d':1000.0,
            'patch_len': 16,
            'stride': 8,
            'd_model': 512,
            'factor': 1,
            'd_ff': 2048,
            'n_heads': 8,
            'output_attention': False,
            'activation': 'relu',
            'e_layers': 2,
            'd_layers': 1,
            'dropout': 0.5,
            'alpha': 0.1,
            'w_det': 1.0,
            'w_sto': 0.001,
        },
        'FEDNet_contrastive': {
            'model': 'FEDNet_contrastive',
            'hidden_size': 50,
            'fc_dim': 1984,
            'kernel_size': 9,
            'normalize': False,
            'beta_d': 1.0,
            'beta_y': 1.0,
            'weight_true': 1000.0,
            'weight_false': 1000.0,
            'aux_loss_multiplier_y': 1000.0,
            'aux_loss_multiplier_d':1000.0,
            'patch_len': 16,
            'stride': 8,
            'd_model': 64,
            'factor': 1,
            'd_ff': 2048,
            'n_heads': 8,
            'output_attention': False,
            'activation': 'relu',
            'e_layers': 2,
            'd_layers': 1,
            'dropout': 0.5,
            'alpha': 0.1,
            'w_det': 1.0,
            'w_sto': 0.001,
            'temperature': 0.07,
        },
        'FEDNet_v1': {
            'model': 'FEDNet_v1',
            'hidden_size': 50,
            'fc_dim': 1984,
            'kernel_size': 9,
            'normalize': False,
            'beta_d': 1.0,
            'beta_y': 1.0,
            'weight_true': 1000.0,
            'weight_false': 1000.0,
            'aux_loss_multiplier_y': 1000.0,
            'aux_loss_multiplier_d':1000.0,
            'patch_len': 16,
            'stride': 8,
            'd_model': 512,
            'factor': 1,
            'd_ff': 2048,
            'n_heads': 8,
            'output_attention': False,
            'activation': 'relu',
            'e_layers': 2,
            'd_layers': 1,
            'dropout': 0.5,
            'alpha': 0.1,
            'w_det': 1.0,
            'w_sto': 0.001,
            'temperature': 0.07,
            'constraint_type': 'contrast',
            'freq_type': 'fft'
        },
        'FEDNet_v2': {
            'model': 'FEDNet_v2',
            'hidden_size': 50,
            'fc_dim': 1984,
            'kernel_size': 9,
            'normalize': False,
            'beta_d': 1.0,
            'beta_y': 1.0,
            'weight_true': 1000.0,
            'weight_false': 1000.0,
            'aux_loss_multiplier_y': 1000.0,
            'aux_loss_multiplier_d':1000.0,
            'patch_len': 16,
            'stride': 8,
            'd_model': 512,
            'factor': 1,
            'd_ff': 2048,
            'n_heads': 8,
            'output_attention': False,
            'activation': 'relu',
            'e_layers': 2,
            'd_layers': 1,
            'dropout': 0.5,
            'alpha': 0.1,
            'w_det': 1.0,
            'w_sto': 0.001,
            'temperature': 0.07,
            'constraint_type': 'contrast',
            'freq_type': 'fft'
        },
    }

    return model_hparams[model_name]