def LSA64_model(model_name):
    """ LSA64 model hparam definition """
    model_hparams = {
            'CRNN': {
            'model': 'CRNN',
            # Classifier
            'hidden_depth': 1,
            'hidden_width': 64,
            # LSTM
            'recurrent_layers': 2,
            'state_size': 128,
            # Resnet encoder
            'fc_hidden': (512,512),
            'CNN_embed_dim': 256
        },
        'FreTS': {
            'model': 'FreTS'
        },
        'PatchTST': {
            'model': 'PatchTST'
        },
        'FEDNet': {
            'model': 'FEDNet',
            'hidden_size': 50,
            'fc_dim': 192,
            'kernel_size': 9,
            'normalize': True,
            'beta_d': 1.0,
            'beta_y': 1.0,
            'weight_true': 1000.0,
            'weight_false': 1000.0,
            'aux_loss_multiplier_y': 1000.0,
            'aux_loss_multiplier_d':1000.0,
            'patch_len': 16,
            'stride': 8,
            'd_model': 512,
            'factor': 1,
            'd_ff': 2048,
            'n_heads': 8,
            'output_attention': False,
            'activation': 'relu',
            'e_layers': 2,
            'd_layers': 1,
            'dropout': 0.5,
            'alpha': 0.1
        }
    }

    return model_hparams[model_name]