def PCL_model(model_name):
    """ PCL model hparam definition"""
    model_hparams = {
        'EEGNet': {
            'model': 'EEGNet'
        },
        'FreTS': {
            'model': 'FreTS'
        },
        'PatchTST': {
            'model': 'PatchTST'
        },
        'FEDNet': {
            'model': 'FEDNet',
            'hidden_size': 50,
            'fc_dim': 3008,
            'kernel_size': 9,
            'normalize': True,
            'beta_d': 1.0,
            'beta_y': 1.0,
            'weight_true': 1000.0,
            'weight_false': 1000.0,
            'aux_loss_multiplier_y': 1000.0,
            'aux_loss_multiplier_d':1000.0,
            'patch_len': 16,
            'stride': 16,
            'd_model': 512,
            'factor': 1,
            'd_ff': 2048,
            'n_heads': 8,
            'output_attention': False,
            'activation': 'relu',
            'e_layers': 2,
            'd_layers': 1,
            'dropout': 0.5,
            'alpha': 0.1,
            'w_inv': 1.0,
            'w_det': 0.001,
        },
        'AdaRNN': {
            'model': 'AdaRNN',
            'use_bottleneck': False,
            'bottleneck_width': 256,
            'n_hiddens': [64,64],
            'dropout': 0.5,
            'model_type': 'AdaRNN',
            'trans_loss': 'mmd',
        },
        'GILE': {
            'model': 'GILE',
            'fc_dim': 3008,
            'd_AE': 50,
            'beta_d': 1.0,
            'beta_y': 1.0,
            'weight_true': 1000.0,
            'weight_false': 1000.0,
            'aux_loss_multiplier_y': 1000.0,
            'aux_loss_multiplier_d':1000.0,
            'kernel_size': 9,
        },
        'FEDNet_v1': {
            'model': 'FEDNet_v1',
            'hidden_size': 50,
            'fc_dim': 3008,
            'kernel_size': 9,
            'normalize': True,
            'beta_d': 1.0,
            'beta_y': 1.0,
            'weight_true': 1000.0,
            'weight_false': 1000.0,
            'aux_loss_multiplier_y': 1000.0,
            'aux_loss_multiplier_d':1000.0,
            'patch_len': 16,
            'stride': 8,
            'd_model': 512,
            'factor': 1,
            'd_ff': 2048,
            'n_heads': 8,
            'output_attention': False,
            'activation': 'relu',
            'e_layers': 2,
            'd_layers': 1,
            'dropout': 0.5,
            'alpha': 0.1,
            'w_inv': 1.0,
            'w_det': 0.001,
        },
        'FEDNet_v2': {
            'model': 'FEDNet_v2',
            'hidden_size': 50,
            'fc_dim': 3008,
            'kernel_size': 9,
            'normalize': True,
            'beta_d': 1.0,
            'beta_y': 1.0,
            'weight_true': 1000.0,
            'weight_false': 1000.0,
            'aux_loss_multiplier_y': 1000.0,
            'aux_loss_multiplier_d':1000.0,
            'patch_len': 16,
            'stride': 8,
            'd_model': 512,
            'factor': 1,
            'd_ff': 2048,
            'n_heads': 8,
            'output_attention': False,
            'activation': 'relu',
            'e_layers': 2,
            'd_layers': 1,
            'dropout': 0.5,
            'alpha': 0.1,
            'w_inv': 1.0,
            'w_det': 0.001,
        },
    }

    return model_hparams[model_name]
