# FEDNet: Frequency Enhanced Decomposed Network for Out-of-Distribution Time Series Classification

This repository is the official implementation of "FEDNet: Frequency Enhanced Decomposed Network for Out-of-Distribution Time Series Classification".

## Environment
- Python 3.9.12
- PyTorch 2.3.0+cu121
- CUDA: 12.4

## Dataset
We collected all the open-source datasets in `data` directory of the repository.
- `UCIHAR`, `SHAR` (UniMiB-SHAR), `OPP` (Opportunity) can be downloaded from its origin [Google Drive Link](https://drive.google.com/drive/folders/1S4oGTs8ChD8ezmxOrnqcboWVWHvT7CdH).
- `Spurious_Fourier` (synthetic dataset) and `HHAR` will be created automatically when run the scripts in `WOODS-Benchmark`.
- `EMG` can be downloaded from [robustlearn/diversify](https://github.com/microsoft/robustlearn/tree/main/diversify), it provided the processed data. 
- `DSADS` official processed dataset can be downloaded [dsads_x](https://wjdcloud.blob.core.windows.net/dataset/lwdata/act/dsads/dsads/dsads_x.npy), [dsads_y](https://wjdcloud.blob.core.windows.net/dataset/lwdata/act/dsads/dsads/dsads_y.npy)
- [`PAMAP`](https://archive.ics.uci.edu/dataset/231/pamap2+physical+activity+monitoring) and [`EEG`](https://researchdata.ntu.edu.sg/dataset.xhtml?persistentId=doi:10.21979/N9/UD1IM9) need to be processed by python scripts in `data_preprocess` directory after downloading. 

```bash
data
    ├── DSADS
    ├── EEG
    ├── EMG
    ├── HHAR
    ├── OPP
    ├── PAMAP
    ├── SHAR
    ├── UCIHAR
```

## Requirements

To install requirements:

```bash
conda create --name FEDNet python=3.9.12
conda activate FEDNet
conda install pytorch==2.3.0 torchvision==0.18.0 torchaudio==2.3.0 pytorch-cuda=12.1 -c pytorch -c nvidia
conda install tensorboard
pip install -r requirements.txt
```

## Reproduction

### Data Preprocess
We made `PAMAP` datasets following the instructions in Diversify[1] because the author didn't provide them. The detail prprocess codes are in `data_preprocess` directory.

### FEDNet-TSLib-version
We adopt FEDNet with `Time-Series-Library` for general codebase to any dataset (w/o domain information). It is used for `UCIHAR`, `SHAR`, `Opportunity`, `EMG`, `DSADS`, `PAMAP` datasets which the same pipeline (training, evaluation, balance strategy) as Diversify and GILE[2].

To train the model(s) in the paper, please run the command in `FEDNet-TSLib-version/scripts`, here we provide an example. After training, you can check the result in `results` and training process for tensorboard visualization in `runs`.
```bash
cd FEDNet-TSLib-version
python3 run.py --model FEDNet --data UCIHAR --n_features 9 --n_domains 5 --len_seq 128 --target_domain 0 --fc_dim 512 --kernel_size 5 --alpha 0.2 --balance
```
We also provide the origin code Diversify and GILE in `baseline` directory since their process are quite different and hard for adapting to main codebase. We also combined Diversify with other domain generalization methods for training. The scripts `diversify_script.sh` and `dg_method.sh` exit in `baseline/diversify`.

### WOODS-Benchmark
if you want to run the dataset in WOODS-Benchmark[3], please enter `WOODS-Benchmark` directory and install woods for python-library first.
```bash
cd WOODS-Benchmark
pip install setuptools
python3 setup.py install
```
We tested FEDNet with `Spurious_Fourier`, `HHAR`, `DSADS_CROSSPOSITION` in the origin WOODS-benchmark codebase to ensure its right reproduction. We list all the scripts in `WOODS-Benchmark/cmd` directory.
Here also provide an instance to help you understand how to use the benchmark.
```bash
cd WOODS-Benchmark
python3 -m woods.scripts.main train --dataset Spurious_Fourier --objective FEDNet --test_env 0 --model_name FEDNet --alpha 0.1 --save_path ./results/Spurious_Fourier/FEDNet/alpha010 --save --device 0
```

## Contributing
MIT LICENSE.

## Reference
[1]. Lu W, Wang J, Sun X, et al. Out-of-distribution representation learning for time series classification[J]. arXiv preprint arXiv:2209.07027, 2022.

[2]. Qian, H., Pan, S. J., & Miao, C. (2021). Latent Independent Excitation for Generalizable Sensor-based Cross-Person Activity Recognition. Proceedings of the AAAI Conference on Artificial Intelligence, 35(13), 11921-11929. https://doi.org/10.1609/aaai.v35i13.17416

[3]. Gagnon-Audet J C, Ahuja K, Darvishi-Bayazi M J, et al. WOODS: Benchmarks for out-of-distribution generalization in time series[J]. arXiv preprint arXiv:2203.09978, 2022.

## Related Links
This codebase is adopted from their great work.
- [thuml/Time-Series-Library](https://github.com/thuml/Time-Series-Library)
- [microsoft/robustlearn](https://github.com/microsoft/robustlearn)
- [jc-audet/WOODS](https://github.com/jc-audet/WOODS)
- [Hangwei12358/cross-person-HAR](https://github.com/Hangwei12358/cross-person-HAR)
