import pandas as pd
import numpy as np
import tensorflow as tf

import tensorflow as tf

from sklearn.preprocessing import MinMaxScaler
from sklearn.decomposition import PCA
from sklearn.model_selection import train_test_split
from sklearn.preprocessing import LabelEncoder
from sklearn.neural_network import MLPClassifier
from sklearn.datasets import make_circles
from tensorflow.keras.models import Sequential
from tensorflow.keras.layers import Dense


def save_weights(weights_list, biases_list, fname='weights_and_biases'):
    weights_and_biases_dict = {f'weights_{i}': weights for i, weights in enumerate(weights_list)}
    weights_and_biases_dict.update({f'biases_{i}': biases for i, biases in enumerate(biases_list)})
    weights_and_biases_dict.update({'number_layers': len(weights_list)})

    np.savez(f'{fname}.npz', **weights_and_biases_dict)

def load_weights(fname='weights_and_biases'):
    loaded = np.load(f'{fname}.npz')
    number_layers = loaded['number_layers']
    weights_list = [loaded[f'weights_{i}'] for i in range(0, number_layers)]
    biases_list = [loaded[f'biases_{i}'] for i in range(0, number_layers)]
    return weights_list, biases_list

def save_data(test_x, test_y, fname='data'):
    data_dict = {'test_x': test_x, 'test_y': test_y}
    np.savez(f'{fname}.npz', **data_dict)

def load_data(fname='data'):
    loaded = np.load(f'{fname}.npz')
    return loaded['test_x'], loaded['test_y']

def rand_initialisation(X_train, X_test, y_train, y_test, fname):
    
   # X_train1, X_train2, y_train1, y_train2 = train_test_split(X_train, y_train, test_size= split, random_state=random_state)


    # Build Model
    model = Sequential([
        Dense(12, input_dim=2, activation='relu'),  # Hidden layer with 12 units
        Dense(1, activation='sigmoid')  # Output layer
    ])
    model.compile(optimizer=tf.keras.optimizers.Adam(learning_rate=0.001), 
                loss='binary_crossentropy', 
                metrics=['accuracy'])

    model.fit(
    X_train, y_train,
    validation_data= (X_test, y_test),  # Using 20% of training data for validation
    epochs=70  # Maximum number of epochs
    )





    weights_list1 = []
    biases_list1 = []

    # Iterate over the dense layers of the model
    for layer in model.layers:
        # save all weights (including for the sigmoid layer)
        if isinstance(layer, Dense):
            weights, biases = layer.get_weights()
            weights_list1.append(weights)
            biases_list1.append(biases)

    save_weights(weights_list1, biases_list1, f'weights_and_biases_{fname}')



    model2 = Sequential([
        Dense(12, input_dim=2, activation='relu'),  # Hidden layer with 12 units
        Dense(1, activation='sigmoid')  # Output layer
    ])
    model2.compile(optimizer=tf.keras.optimizers.Adam(learning_rate=0.001), 
                loss='binary_crossentropy', 
                metrics=['accuracy'])

    model2.fit(
    X_train, y_train,
    validation_data= (X_test, y_test),  # Using 20% of training data for validation
    epochs=70  # Maximum number of epochs
    )
    
    
    weights_list2 = []
    biases_list2 = []

    # Iterate over the dense layers of the model
    for layer in model2.layers:
        # save all weights (including for the sigmoid layer)
        if isinstance(layer, Dense):
            weights, biases = layer.get_weights()
            weights_list2.append(weights)
            biases_list2.append(biases)

    save_weights(weights_list2, biases_list2, f'weights_and_biases_{fname}2')

    save_data(X_train, y_train, f'train_data_{fname}_1')
    save_data(X_train, y_train, f'train_data_{fname}_2')


def rand_subsets(X_train, X_test, y_train, y_test, fname, random_state = 32, split = 0.5):

    X_train1, X_train2, y_train1, y_train2 = train_test_split(X_train, y_train, test_size= split, random_state=random_state)
    
    # Build Model
    model = Sequential([
        Dense(12, input_dim=2, activation='relu'),  # Hidden layer with 12 units
        Dense(1, activation='sigmoid')  # Output layer
    ])
    model.compile(optimizer=tf.keras.optimizers.Adam(learning_rate=0.001), 
                loss='binary_crossentropy', 
                metrics=['accuracy'])

    model.fit(
    X_train1, y_train1,
    validation_data= (X_test, y_test),  # Using 20% of training data for validation
    epochs=70  # Maximum number of epochs
    )
   
    weights_list1 = []
    biases_list1 = []

    # Iterate over the dense layers of the model
    for layer in model.layers:
        # save all weights (including for the sigmoid layer)
        if isinstance(layer, Dense):
            weights, biases = layer.get_weights()
            weights_list1.append(weights)
            biases_list1.append(biases)

    save_weights(weights_list1, biases_list1, f'weights_and_biases_{fname}')
    
    # Build Model
    model2 = Sequential([
        Dense(12, input_dim=2, activation='relu'),  # Hidden layer with 12 units
        Dense(1, activation='sigmoid')  # Output layer
    ])
    model2.compile(optimizer=tf.keras.optimizers.Adam(learning_rate=0.001), 
                loss='binary_crossentropy', 
                metrics=['accuracy'])

    model2.fit(
    X_train2, y_train2,
    validation_data= (X_test, y_test),  # Using 20% of training data for validation
    epochs=70  # Maximum number of epochs
    )
   
    weights_list2 = []
    biases_list2 = []

    # Iterate over the dense layers of the model
    for layer in model2.layers:
        # save all weights (including for the sigmoid layer)
        if isinstance(layer, Dense):
            weights, biases = layer.get_weights()
            weights_list2.append(weights)
            biases_list2.append(biases)

    save_weights(weights_list2, biases_list2, f'weights_and_biases_{fname}2')

    save_data(X_train1, y_train1, f'train_data_{fname}_1')
    save_data(X_train2, y_train2, f'train_data_{fname}_2')


random_state = 0

x, y = make_circles(n_samples=2000, noise=0.1, random_state=random_state)
X_train, X_test, y_train, y_test = train_test_split(x, y, test_size=0.2, random_state=random_state)



# cut down amount of training data so runs quickly
# X_train = X_train[:1000]
# y_train = y_train[:1000]

save_data(X_test, y_test, 'data_circ')


for i in range(5): # do 5 different initialisations
    # Generate weights and biases file for a random initialisation
    rand_initialisation(X_train, X_test, y_train, y_test, f"randinit_circ_{i}")

