import numpy as np

def save_data(test_x, test_y, fname='data'):
    data_dict = {'test_x': test_x, 'test_y': test_y}
    np.savez(f'{fname}.npz', **data_dict)

def load_data(fname='data'):
    loaded = np.load(f'{fname}.npz')
    return loaded['test_x'], loaded['test_y']

X_test, y_test = load_data('data_circ')

# Create a new array where only the maximum value in each row is retained, and the rest are set to zero
max_value_array = np.zeros_like(X_test)
max_indices = np.argmax(X_test, axis=1)  # Find the index of the max value in each row

# Set the max value in each row, others remain zero
for i, index in enumerate(max_indices):
    max_value_array[i, index] = X_test[i, index]

# If you want to save the modified data back
save_data(max_value_array, y_test, 'data_circle_max_only')