import numpy as np

def save_data(test_x, test_y, fname='data'):
    data_dict = {'test_x': test_x, 'test_y': test_y}
    np.savez(f'{fname}.npz', **data_dict)

def load_data(fname='data'):
    loaded = np.load(f'{fname}.npz')
    return loaded['test_x'], loaded['test_y']

# X_test, y_test = load_data('data_higgs')


# # Shuffle each column independently
# for i in range(X_test.shape[1]):
#     noise = np.random.normal(0, 1, X_test.shape[0])

#     X_test[:, i] = np.sin(X_test[:, i]) + noise

# y_test = np.random.permutation(y_test)
# #We select 1000 points to test
# save_data(X_test[:1000], y_test[:1000], 'data_higgs_ood_nonlinear')
X_test, y_test = load_data('data_higgs')

# We select 1000 points to test
X_test = X_test[:2000] 
y_test = y_test[:2000]

# Shuffle each column independently for the selected 1000 points
for i in range(X_test.shape[1]):
    noise = np.random.normal(0, 1, X_test.shape[0])
    X_test[:, i] = np.sin(X_test[:, i]) + noise

y_test = np.random.permutation(y_test)

# Save the data
save_data(X_test, y_test, 'data_higgs_ood_nonlinear')