import numpy as np

def save_data(test_x, test_y, fname='data'):
    data_dict = {'test_x': test_x, 'test_y': test_y}
    np.savez(f'{fname}.npz', **data_dict)

def load_data(fname='data'):
    loaded = np.load(f'{fname}.npz')
    return loaded['test_x'], loaded['test_y']

X_test, y_test = load_data('data_higgs')

# We select 1000 points to test
X_test = X_test[:2000]
y_test = y_test[:2000]


# Get the number of columns in X_test
num_columns = X_test.shape[1]

# Generate a random permutation of the column indices
permuted_indices = np.random.permutation(num_columns)

# Rearrange the columns of X_test based on the permuted indices
X_test_permuted = X_test[:, permuted_indices]

# Save the rearranged data if needed
save_data(X_test_permuted, y_test, 'data_higgs_permuted')