import numpy as np

def save_data(test_x, test_y, fname='data'):
    data_dict = {'test_x': test_x, 'test_y': test_y}
    np.savez(f'{fname}.npz', **data_dict)

def load_data(fname='data'):
    loaded = np.load(f'{fname}.npz')
    return loaded['test_x'], loaded['test_y']

X_test, y_test = load_data('data_skin')

# Assuming the first three columns are RGB, apply color inversion
X_test[:, 0:3] =  - X_test[:, 0:3]

save_data(X_test, y_test, 'data_skin_ood1')
