import numpy as np

def save_data(test_x, test_y, fname='data'):
    data_dict = {'test_x': test_x, 'test_y': test_y}
    np.savez(f'{fname}.npz', **data_dict)

def load_data(fname='data'):
    loaded = np.load(f'{fname}.npz')
    return loaded['test_x'], loaded['test_y']

X_test, y_test = load_data('data_skin')

# Shuffle each column independently
#for i in range(X_test.shape[1]):
 #   X_test[:, i] = np.random.permutation(X_test[:, i])
    
# Set the first feature (e.g., 'B') to a constant value
X_test[:, 0] = 0.5  # You can choose any constant value

# Apply a non-linear transformation to the second feature (e.g., 'G') to alter its distribution
# For example, taking the square root, which can significantly change the distribution
X_test[:, 1] = np.sqrt(X_test[:, 1])

# Scale the third feature (e.g., 'R') by a factor that makes its distribution different
# For example, multiplying by a large number or applying a logarithmic transformation
# Here we use a logarithmic transformation, adding a small constant to avoid log(0) issues
X_test[:, 2] = np.log(X_test[:, 2] + 1e-5)

# Now, X_np is an out-of-distribution dataset relative to the original X
# with one constant feature, and two other features having very different distributions
    

#y_test = np.random.permutation(y_test)

save_data(X_test, y_test, 'data_skin_ood2')