from .implementations import model_map


class ModelFactory:
    @staticmethod
    def create_model(model_name, model_config):
        """Create and return an LLM instance based on name and config"""
        if model_name in model_map:
            return model_map[model_name](**model_config)
        else:
            raise ValueError(f"Unknown model type: {model_name}; Available ones are: {model_map.keys()}")
