import setuptools

from torch.utils import cpp_extension


setuptools.setup(
    name="mnn",
    version="0.0.1",
    description="Scalable Mechanistic Neural Network.",
    install_requires=["torch",],
    packages=setuptools.find_packages(exclude=["docs", "examples", "tests"]),
    ext_modules=[
        cpp_extension.CppExtension(
            "mnn_cpp",
            [
                "mnn/mnn_cpp.cpp",
            ],
        ),
    ],
    cmdclass={"build_ext": cpp_extension.BuildExtension},
)
