from enum import Enum


class SolverType(Enum):
    DENSE_CHOLESKY = 1
    SPARSE_QR = 10
    SPARSE_INDIRECT_CG = 100
    SPARSE_INDIRECT_BLOCK_CG = 1000
    LEAST_SQUARES = 10000


class ODEConfig:
    # uncomment to choose linear solver sparse conjuate gradient
    linear_solver = SolverType.LEAST_SQUARES
    # linear_solver = SolverType.DENSE_CHOLESKY
    # linear_solver = SolverType.SPARSE_INDIRECT_BLOCK_CG

    central_diff: bool = True
    cg_max_iter: int = 200
