# GCN for Graph Classification & Triangle Counting

This code was adapted starting from the following repo: <https://github.com/bknyaz/graph_nn>.

## Requirements
* PyTorch 0.4.1 (or greater)
* NetworkX
* SciPy

## Instructions
The first time you launch this program using random walk features, it will generate and 
save random walk statistics for all graphs in the considered dataset. 
This may take a while, specially for large graphs, and it will take space on disk.
This only happens the first time for each dataset, then the program will read the saved 
random walk statistics from disk.

### Graph Classification
Instructions are reported for experiments on the ENZYMES dataset, if you want to run on DD
or PROTEINS, just replace "ENZYMES" with "DD" or "PROTEINS" in the instructions below.

* Train and validate GCN

```python graph_unet.py -c --dataset ENZYMES -f 128,128 --n_hidden 256 --lr 0.0005 --epochs 200 --lr_decay_step 150 --feat_addition 0 --laplacian_reg 0```

* Train and validate GCN-AD 

```python graph_unet.py -c --dataset ENZYMES -f 128,128 --n_hidden 256 --lr 0.0005 --epochs 200 --lr_decay_step 150 --feat_addition 1 --laplacian_reg 0```

* Train and validate GCN-RW

```python graph_unet.py -c --dataset ENZYMES -f 128,128 --n_hidden 256 --lr 0.0005 --epochs 200 --lr_decay_step 150 --feat_addition 2 --laplacian_reg 0```

* Train and validate GCN-RW+RWReg

```python graph_unet.py -c --dataset ENZYMES -f 128,128 --n_hidden 256 --lr 0.0005 --epochs 200 --lr_decay_step 150 --feat_addition 2 --laplacian_reg 1```

### Triangle Counting

* Train and validate GCN

```python graph_unet.py -D TRIANGLES --folds 1 -c --degree --feat_addition 0```

* Train and validate GCN-AD 

```python graph_unet.py -D TRIANGLES --folds 1 -c --degree --feat_addition 1```

* Train and validate GCN-RW

```python graph_unet.py -D TRIANGLES --folds 1 -c --degree --feat_addition 2```

* Train and validate GCN-RW+RWReg

```python graph_unet.py -D TRIANGLES --folds 1 -c --degree --feat_addition 2 --laplacian_reg 1```