# GraphSage

This code was adapted starting from the following repo: <https://github.com/williamleif/graphsage-simple/>.

## Requirements
* PyTorch 0.2 (or greater)
* NetworkX 1.11 (version number is important!)
* hyperopt 0.1
* SciPy

## Instructions
The first time you launch this program using random walk features, it will generate and
save random walk statistics for the considered dataset. 
This may take a while, specially for large graphs, and it will take space on disk.
This only happens the first time for each dataset, then the program will read the saved 
random walk statistics from disk.

Instructions are reported for experiments on the Cora dataset, if you want to run on Pubmed
or Citeseer, just replace "cora" with "pubmed" or "citeseer" in the instructions below.

* Train and validate GraphSage

```python model.py --dataset cora --num_experiments 100```

* Train and validate GraphSage-AD 

```python model.py --dataset cora --num_experiments 100 --feat_addition 1```

* Train and validate GraphSage-RW

```python model.py --dataset cora --num_experiments 100 --feat_addition 2```

* Train and validate GraphSage-RW+RWReg

```python model.py --dataset cora --num_experiments 100 --feat_addition 2 --laplacian_reg 1```

* To perform hyperparameter (RWReg term, learning rate) tuning use the "optimize" flag:

```python model.py --dataset cora --num_experiments 100 --feat_addition 2 --laplacian_reg 1 --optimize 1```
