# ImpressLearn

## Environment set-up

We include requirements file in `requirements.txt`. Make a new virtual environment in your favorite environment manager (conda, virtualenv) and run `pip install -r requirements.txt`.

### How to run an experiment

Go to the root directory of this code repository and invoke one of the scripts from above with `--gpu-sets`, `--seeds`, and `--data` flags, e.g.

```
python experiments/seeds/splitcifar100/rn18-supsup.py --gpu-sets="0|1|2|3" --data=/path/to/dataset/parent --seeds 1
```

The `--data` flag is the path to the folder which contains the required dataset, in this case CIFAR100 or ImageNet, which we then split into tasks. CIFAR100 will be automatically downloaded if it's not in `--data`, ImageNet will not. `--seeds` says how many seeds (from 0 to `--seeds - 1` to evaluate on. For all of our reported SplitCIFAR100 experiments we use 5. Our reported experiments for SplitImageNet are with 1 seed (with fixed ImageNet split). The default number of seeds in this repo is 1.

These models can be trained on each task individually. As such these scripts are built to take advantage of parallelism. The `--gpu-sets` command takes comma-separated sets of GPUs separated by `|`. For example, `--gpu-sets="0|1|2|3"` means that each experiment will be run individually on a GPU with ID in [0, 1, 2, 3]. If you want to use multiple GPUs per experiment, say for ResNet-50 on SplitImagenet, you can specify this by using comma-separated lists. For example, `--gpu-sets="0,1|2,3"` means that each task will be trained invidually (in parallel) either on GPUs {0, 1} or {2, 3}. Specifying a lone gpu, `--gpu-sets=0`, means that experiments will be run sequentially on GPU 0.

### Where are the results stored?

Results are automatically stored after each run in the `runs/<experiment-name>` folder, where `<experiment-name>` is the name of the script file (sans `.py` extension). The actual numbers corresponding to our plot are stored in `runs/<experiment-name>/results.csv` where each row has a self-explanatory `Name` column describing what the result is.


#### Local Installation:
```
create conda new env
pip install -r requirements.txt
```
