function [Datas, parameters] = PrepData2(Datas, parameters)

i = parameters.data.i;
j = parameters.data.j;

switch parameters.data.validationType
    case 'Kfold'
        ivector = 1:parameters.data.Kfold:parameters.data.A; 
        jvector = 1:parameters.data.Kfold:parameters.data.B; 
        
        istart = ivector(i); 
        jstart = jvector(j);
        
        %%
        switch i <= parameters.data.NAvals(end)
            case true, iend = istart + parameters.data.Kfold -1;
            case false, iend = parameters.data.A;
        end
        
        switch j <= parameters.data.NBvals(end)
            case true, jend = jstart + parameters.data.Kfold -1;
            case false, jend = parameters.data.B;
        end

        iTesting = istart:iend;
        jTesting = jstart:jend;

    case 'Synthetic'

        iTesting = 1:parameters.data.Kfold;
        jTesting = 1:parameters.data.Kfold;  

    case 'Cross'
        iTesting = [];
        jTesting = [];
end






TestingA = Datas.rawdata.AData(:,iTesting);
TestingB = Datas.rawdata.BData(:,jTesting);

TrainingA = Datas.rawdata.AData(:,:); 
TrainingB = Datas.rawdata.BData(:,:);
TrainingA(:,iTesting) = []; 
TrainingB(:,jTesting) = []; 

if strcmp(parameters.data.validationType,'Cross')
        T = readtable(sprintf('%s%s_Training.txt', parameters.data.path, parameters.data.label));
        TestingA = table2array(T(:,startsWith(T.Properties.VariableNames, parameters.data.typeA)));
        TestingB = table2array(T(:,startsWith(T.Properties.VariableNames, parameters.data.typeB)));
end



iData = 1:size(TrainingA,2);
if parameters.multilevel.splitTraining
    nTesting = size(TrainingB,2);
    iCov = iData(iData <= nTesting);
else
    iCov = iData;
end

meanXA = mean(TrainingA(:,iCov), 2);


Datas.A.Testing = TestingA - meanXA;
Datas.B.Testing = TestingB - meanXA;
Datas.A.Training = TrainingA - meanXA;
Datas.B.Training = TrainingB - meanXA ; 


%if parameters.transform.ComputeTransform
Datas = UpdateCovariance(Datas, parameters);






end


