function plotAUCs2
close all

DataSets = ["SOMAscan7k_KNNimputed_AD_CN"];
DataAliases = ["CSF"];
resultFolder = '18';
CrossVal = 'Kfold';



%% Set Plot Parameters
YTicks = 0.5:0.1:1;
YTickLabels = num2cell(YTicks); YTickLabels(1:2:end) = {''};
axNames = {'YLim', 'YGrid', 'fontsize', 'YTickMode', 'ytick','YTickLabels'};
axValues = {[0.5, 1], 'on', 11, 'manual', YTicks, YTickLabels};
LineArgs = {'LineWidth', 2, 'Marker', 's', 'MarkerSize', 10, 'MarkerFaceColor', 'auto'};
AxlabelArgs = {'Interpreter', 'latex', 'FontSize', 13};

Balances = ["Balanced", "Unbalanced"];
Accs = ["AUC", "accuracy"];
capitalize = @(str) upper(extractBefore(str,2)) + extractAfter(str,1);

LineColors = [0.12, 0.21, 1;
             1, 0.04, 0.12;
             0.25, 0.25, 0.25];

%% Get Baseline Machine Performace

% BaselineAUC = nan(size(ADNIs));
% BaselineMachine = string(size(ADNIs));


%% Iterate over ADNIs, Balances, and Accuracy measures

for iacc = 1:length(Accs)
    Acc = Accs(iacc);
for iDS = 1:length(DataSets)

    % if strcmp(Acc, "ErrorRate")
    %     Baseline.(Acc)(iADNI) = 1 - Baseline.accuracy(iADNI);
    %     continue
    % end

    DS = DataSets(iDS);
    
    %ADNI  = sprintf('Plasma_M12_%s', ADNI2);
    folderpath = fullfile('..','results',resultFolder,CrossVal,DS, 'Leave 1 out', 'Unbalanced');
    X = dir(folderpath);
    X(1:2) = [];
    X = {X.name};
    iX = cellfun(@(x) contains(x, 'SVMOnly'), X);
    X = X{iX}; %X = X{1};
    r = load(fullfile(folderpath, X));
    [Baseline.(Acc)(iDS), iBest] = max(r.results.(Acc));
    BaselineMachine.(Acc)(iDS) = r.parameters.misc.MachineList(iBest);
    BaselineMachine.runTime(iDS) = r.results.DimRunTime(iBest);
end
end


for iacc = 1:length(Accs)
    
    Acc = Accs(iacc);
iplot = 0;
for iDS = 1:length(DataSets)
    DS = DataSets(iDS);
    DA = DataAliases(iDS);
    %ADNI  = sprintf('Plasma_M12_%s', DS);
    f = figure('units','normalized','outerposition',[0 0 0.6 0.45]);

for iBalance = 1:length(Balances)

        Balance = Balances(iBalance);
        
        folderpath = fullfile('..','results', resultFolder, CrossVal, DS, 'Leave 1 out', Balance);
        X = dir(folderpath);
        X(1:2) = [];
        X = {X.name};
        iX = cellfun(@(x) contains(x, '.mat'), X); X = X(iX);

        X = cellfun(@(x) load(fullfile(folderpath, x)) , X);
        
        %X = X(iX);
        svmonly = arrayfun(@(x) x.parameters.multilevel.svmonly, X);
        %svmonly = unique(svmonly);

        %iplot = sub2ind([3,2], iADNI, iBalance);
        iplot = iplot + 1;
        
        ax = subplot(1,2,iBalance); hold on, 
        ax.Position(2) = 0.18; ax.Position(4) = 0.65;
        title({replace(DA, '_', '\_'), Balance}, ...
            'FontSize', 13, 'Interpreter', 'latex'); %, 'FontName', 'Times New Roman');
        cellfun(@(x,y) set(ax,x,y), axNames, axValues);
        
        %title(sprintf('%s \\ %s', DS, Balance), AxlabelArgs{:})
        

        
        %disp(xlabeltext.Position);
        %xlabeltext.Position = xlabelPos + [0,0.02,0];
        %xlabeltext.HorizontalAlignment = 'center';
        ylabel(capitalize(Acc), AxlabelArgs{:});
       
        legstr = {};
        

for isvm = [2,0,1]
    jsvm = svmonly == isvm;
    x = X(jsvm); 
    LineColor = LineColors(isvm+1,:);
    mytext = @(x,y,t) text(x,y,sprintf('%0.1f',t), 'Fontsize', 9, 'Color',LineColor);

    BestAccList = arrayfun(@(y) max(y.results.(Acc)), x);
    [~,iBestAcc] = max(BestAccList);
    Bestx = x(iBestAcc);


switch isvm
    case 1 
        
        %% Miscellaneous Machines    
        xval = [0, Bestx.parameters.data.numofgene; ]; %get(ax, 'XLim'); 
        legstr = [legstr{:}, BaselineMachine.(Acc)(iDS)];
        P = [xval ; Baseline.(Acc)(iDS) * [1,1]] ;
        
        plot(ax, P(1,:), P(2,:), 'Color', LineColor, LineArgs{:}); 
        %mytext(mean(xval), Baseline.(Acc)(iADNI) - 0.05, BaselineMachine.runTime(iADNI));
    
    case 0 
        
        %% Multilevel Orthogonal Subspace Filter

        switch Bestx.parameters.svm.kernal, case true, s = 'w/ RBF'; case false, s = 'w/ Linear'; end
        legstr = [legstr{:}, {sprintf('MLS %s', s)}];
        plot(ax, Bestx.parameters.multilevel.Mres, Bestx.results.(Acc), ...
            'Color', LineColor, LineArgs{:});   
        
        %arrayfun(mytext, Bestx.parameters.multilevel.Mres + 8, Bestx.results.(Acc) - 0.06, Bestx.results.DimRunTime);

    case 2

        %% Anomalous Class Adapted Filter
        % BestAccList = arrayfun(@(y) max(y.results.(Acc)), x);
        % setfield(Bestx.results, Acc, 1 - Bestx.results.accuracy);
        % [~,iBestAcc] = max(BestAccList);
        % Bestx = x(iBestAcc);
        % Bestx.results.ErrorRate = 1 - Bestx.results.accuracy;
        switch Bestx.parameters.svm.kernal, case true, s = 'w/ RBF'; case false, s = 'w/ Linear'; end
        eigentag = upper(Bestx.parameters.multilevel.eigentag(1));
        legstr = [legstr{:}, {sprintf('ACA-%s %s', eigentag, s)}];

            
        

        plot(ax, Bestx.parameters.multilevel.Mres, Bestx.results.(Acc), ...
            'Color', LineColor, LineArgs{:});
        %arrayfun(mytext, Bestx.parameters.multilevel.Mres - 8, Bestx.results.(Acc) + 0.06, Bestx.results.DimRunTime);
 


end


end

    %% Place and size legend
    % ax = subplot(1,2,iplot);
    % axpos = get(ax,'Position');
    % axwidth = axpos(3);
    % axheight = axpos(4);
    % axright = axpos(1) + axpos(3);
    % axbottom = axpos(2);
    % 
    % legwidth = 0.5*axwidth;
    % legheight = 0.22*axheight ;
    % 
    % legleft = axright - 0.01 - legwidth;
    % legbottom = axbottom + 0.025;
    % 
    % legpos = [legleft, legbottom, legwidth, legheight];
    % 
    set(ax, 'xlim', [0, Bestx.parameters.data.numofgene]);
    switch Acc
        case "AUC"
            %legend(legstr, 'position', legpos, 'Interpreter', 'none', 'FontSize',9);
            legend(legstr, 'Location', 'best', 'Interpreter', 'none', 'FontSize',9);
        case "accuracy"
            legend(legstr, 'Location', 'best', 'Interpreter', 'none', 'FontSize',9);
    end

    xlabelpos = mean(get(gca, 'xlim'));
    xlabeltext = xlabel('$M_{res}$', AxlabelArgs{:}, 'Position', [xlabelpos, 0.43, 0]); 



    
end

plotPath = fullfile('..','results',resultFolder,CrossVal, 'Graphs');
if ~isfolder(plotPath), mkdir(plotPath), end
exportgraphics(f, fullfile(plotPath, sprintf('%s_%s.pdf', DS, Acc)));
close(f)
    
end






end 

end