# Spectrally Transformed Kernel Regression

This is an implementation of STKR-Prop, a scalable iterative method for solving a Spectrally Transformed Kernel Regression. 

# Prerequisites
* Numpy
* Scipy
* Pytorch
* Pytorch-Geometric


# STKR-Prop
Suppose that we have a base kernel $K$ that capture the inter-sample similarity between samples. Let the spectral decomposition be $K(x,x') = \sum_{i=1}^{\infty} \lambda_i \psi_i(x) \psi_i(x')$. A \textit{spectrally transformed kernel} (STK) is defined as $K_s(x,x') = \sum_i s(\lambda_i) \psi_i(x) \psi_i(x')$,
where $s: [0, +\infty) \rightarrow [0, +\infty)$ is a  transformation function.
We call the kernel regression with respect to the STK $K_s$, \textit{spectrally transformed kernel regression} (STKR).
## STKR-poly
This section provide an implementation of STKR when the transformation function $s$ can be written as a polynomial. Our model takes the gram matrix $G_K \in \mathbb{R}^{(n+m) \times (n+m)}$ of the base kernel $K$, the target value $y \in \mathbb{R}^{n}$, train mask, and a polynomial $s$. The input `s = [c_0, c_1, \dots]` represents a polynomial $s(\lambda) = c_0 + c_1\lambda + c_2\lambda^2 + \dots$. For instance, if you want to run STKR for $s(\lambda) = \lambda^2$ then you can run the following code. 

```python

model = STKR_inductive()
model.fit(G_K, y, train_mask, s = [0,0,1])
out = model.predict(v)
```
At the inference time, for predicting on a new point $x$, the model take $v(x) \in \mathbb{R}^{n+m}$ where $v(x)_i = K(x, x_i)$ for each training data point $x_i$.


## STKR-Lap
This section provide an implementation of STKR when $s^{-1}$ can be written as a polynomial e.g. inverse Laplacian. Similar to STKR-poly, Our model takes the gram matrix $G_K \in \mathbb{R}^{(n+m) \times (n+m)}$ of the base kernel $K$, the target value $y \in \mathbb{R}^{n}$, train mask, and a polynomial $s^{-1}$. The input `s_inv = [c_0, c_1, \dots]` and `r` represents a polynomial $s^{-1}(\lambda) = c_0\lambda^{-r} + c_1\lambda^{-r + 1} + c_2\lambda^{-r +2} + \dots$. For instance, if you want to run STKR for the inverse Laplacian transformation we know that $s^{-1}(\lambda) = \lambda^{-1} - \eta$ then you can run the following code. 

```python

model = STKR_inductive_sinv()
model.fit(G_K, y, train_mask , s_inv = [1, -eta], r = 1)
out = model.predict(v)
```
Again, at the inference time, for predicting on a new point $x$, the model take $v(x) \in \mathbb{R}^{n+m}$ where $v(x)_i = K(x, x_i)$ for each training data point $x_i$.


## Experiments
In our experiment, we consider publicly available node classification tasks from `Pytorch Geometric` library. We treat the normalized adjacency matrix of the graph as the base kernel.
To replicate the experiments in the paper, one can run the following script
1. Transductive Label Propagation and STKR:  `experiment_transductive.py`
2. Inductive STKR-poly: `experiment_inductive.py`
3. Inductive STKR-Lap: `experiment_inductive_sinv.py`
4. Kernel PCA: `experiment_kernel_pca.py`